/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.metric.jwt.signature;

import java.nio.charset.Charset;
import java.security.Key;
import org.miaixz.bus.auth.metric.jwt.signature.JWTSigner;
import org.miaixz.bus.core.xyz.ByteKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.crypto.center.HMac;

public class HMacJWTSigner
implements JWTSigner {
    private final HMac hMac;
    private Charset charset = org.miaixz.bus.core.lang.Charset.UTF_8;

    public HMacJWTSigner(String algorithm, byte[] key) {
        this.hMac = new HMac(algorithm, key);
    }

    public HMacJWTSigner(String algorithm, Key key) {
        this.hMac = new HMac(algorithm, key);
    }

    public HMacJWTSigner setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    @Override
    public String sign(String headerBase64, String payloadBase64) {
        String data = StringKit.format((CharSequence)"{}.{}", (Object[])new Object[]{headerBase64, payloadBase64});
        return this.hMac.digestBase64(data, this.charset, true);
    }

    @Override
    public boolean verify(String headerBase64, String payloadBase64, String signBase64) {
        String sign = this.sign(headerBase64, payloadBase64);
        return this.hMac.verify(ByteKit.toBytes((CharSequence)sign, (Charset)this.charset), ByteKit.toBytes((CharSequence)signBase64, (Charset)this.charset));
    }

    @Override
    public String getAlgorithm() {
        return this.hMac.getAlgorithm();
    }
}

