/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.metric.jwt.signature;

import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.miaixz.bus.auth.metric.jwt.signature.ECDSAJWTSigner;
import org.miaixz.bus.auth.metric.jwt.signature.HMacJWTSigner;
import org.miaixz.bus.auth.metric.jwt.signature.JWTSigner;
import org.miaixz.bus.auth.metric.jwt.signature.NoneJWTSigner;
import org.miaixz.bus.auth.metric.jwt.signature.RSAJWTSigner;
import org.miaixz.bus.core.center.map.BiMap;
import org.miaixz.bus.core.lang.Algorithm;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.PatternKit;

public class JWTSignerBuilder {
    private static final Pattern ES_ALGORITHM_PATTERN = Pattern.compile("es\\d{3}", 2);
    private static final BiMap<String, String> map = new BiMap((Map)new HashMap<String, String>(){
        {
            this.put("HS256", Algorithm.HMACSHA256.getValue());
            this.put("HS384", Algorithm.HMACSHA384.getValue());
            this.put("HS512", Algorithm.HMACSHA512.getValue());
            this.put("HMD5", Algorithm.HMACMD5.getValue());
            this.put("HSHA1", Algorithm.HMACSHA1.getValue());
            this.put("SM4CMAC", Algorithm.SM4CMAC.getValue());
            this.put("RS256", Algorithm.SHA256WITHRSA.getValue());
            this.put("RS384", Algorithm.SHA384WITHRSA.getValue());
            this.put("RS512", Algorithm.SHA512WITHRSA.getValue());
            this.put("ES256", Algorithm.SHA256WITHECDSA.getValue());
            this.put("ES384", Algorithm.SHA384WITHECDSA.getValue());
            this.put("ES512", Algorithm.SHA512WITHECDSA.getValue());
            this.put("PS256", Algorithm.SHA256WITHRSA_PSS.getValue());
            this.put("PS384", Algorithm.SHA384WITHRSA_PSS.getValue());
            this.put("PS512", Algorithm.SHA512WITHRSA_PSS.getValue());
            this.put("RMD2", Algorithm.MD2WITHRSA.getValue());
            this.put("RMD5", Algorithm.MD5WITHRSA.getValue());
            this.put("RSHA1", Algorithm.SHA1WITHRSA.getValue());
            this.put("DNONE", Algorithm.NONEWITHDSA.getValue());
            this.put("DSHA1", Algorithm.SHA1WITHDSA.getValue());
            this.put("ENONE", Algorithm.NONEWITHECDSA.getValue());
            this.put("ESHA1", Algorithm.SHA1WITHECDSA.getValue());
        }
    });

    public static JWTSigner none() {
        return NoneJWTSigner.NONE;
    }

    public static JWTSigner hs256(byte[] key) {
        return JWTSignerBuilder.createSigner("HS256", key);
    }

    public static JWTSigner hs384(byte[] key) {
        return JWTSignerBuilder.createSigner("HS384", key);
    }

    public static JWTSigner hs512(byte[] key) {
        return JWTSignerBuilder.createSigner("HS512", key);
    }

    public static JWTSigner rs256(Key key) {
        return JWTSignerBuilder.createSigner("RS256", key);
    }

    public static JWTSigner rs384(Key key) {
        return JWTSignerBuilder.createSigner("RS384", key);
    }

    public static JWTSigner rs512(Key key) {
        return JWTSignerBuilder.createSigner("RS512", key);
    }

    public static JWTSigner es256(Key key) {
        return JWTSignerBuilder.createSigner("ES256", key);
    }

    public static JWTSigner es384(Key key) {
        return JWTSignerBuilder.createSigner("ES384", key);
    }

    public static JWTSigner es512(Key key) {
        return JWTSignerBuilder.createSigner("ES512", key);
    }

    public static JWTSigner hmd5(Key key) {
        return JWTSignerBuilder.createSigner("HMD5", key);
    }

    public static JWTSigner hsha1(Key key) {
        return JWTSignerBuilder.createSigner("HSHA1", key);
    }

    public static JWTSigner sm4cmac(Key key) {
        return JWTSignerBuilder.createSigner("SM4CMAC", key);
    }

    public static JWTSigner rmd2(Key key) {
        return JWTSignerBuilder.createSigner("RMD2", key);
    }

    public static JWTSigner rmd5(Key key) {
        return JWTSignerBuilder.createSigner("RMD5", key);
    }

    public static JWTSigner rsha1(Key key) {
        return JWTSignerBuilder.createSigner("RSHA1", key);
    }

    public static JWTSigner dnone(Key key) {
        return JWTSignerBuilder.createSigner("DNONE", key);
    }

    public static JWTSigner dsha1(Key key) {
        return JWTSignerBuilder.createSigner("DSHA1", key);
    }

    public static JWTSigner enone(Key key) {
        return JWTSignerBuilder.createSigner("ENONE", key);
    }

    public static JWTSigner esha1(Key key) {
        return JWTSignerBuilder.createSigner("ESHA1", key);
    }

    public static JWTSigner createSigner(String algorithmId, byte[] key) {
        Assert.notNull((Object)key, (String)"Signer key must be not null!", (Object[])new Object[0]);
        if (null == algorithmId || "none".equals(algorithmId)) {
            return JWTSignerBuilder.none();
        }
        return new HMacJWTSigner(JWTSignerBuilder.getAlgorithm(algorithmId), key);
    }

    public static JWTSigner createSigner(String algorithmId, KeyPair keyPair) {
        Assert.notNull((Object)keyPair, (String)"Signer key pair must be not null!", (Object[])new Object[0]);
        if (null == algorithmId || "none".equals(algorithmId)) {
            return JWTSignerBuilder.none();
        }
        String algorithm = JWTSignerBuilder.getAlgorithm(algorithmId);
        if (PatternKit.isMatch((Pattern)ES_ALGORITHM_PATTERN, (CharSequence)algorithmId)) {
            return new ECDSAJWTSigner(algorithm, keyPair);
        }
        return new RSAJWTSigner(algorithm, keyPair);
    }

    public static JWTSigner createSigner(String algorithmId, Key key) {
        Assert.notNull((Object)key, (String)"Signer key must be not null!", (Object[])new Object[0]);
        if (null == algorithmId || "none".equals(algorithmId)) {
            return NoneJWTSigner.NONE;
        }
        String algorithm = JWTSignerBuilder.getAlgorithm(algorithmId);
        if (key instanceof PrivateKey || key instanceof PublicKey) {
            if (PatternKit.isMatch((Pattern)ES_ALGORITHM_PATTERN, (CharSequence)algorithmId)) {
                return new ECDSAJWTSigner(algorithm, key);
            }
            return new RSAJWTSigner(algorithm, key);
        }
        return new HMacJWTSigner(algorithm, key);
    }

    public static String getAlgorithm(String idOrAlgorithm) {
        return (String)ObjectKit.defaultIfNull((Object)JWTSignerBuilder.getAlgorithmById(idOrAlgorithm), (Object)idOrAlgorithm);
    }

    public static String getId(String idOrAlgorithm) {
        return (String)ObjectKit.defaultIfNull((Object)JWTSignerBuilder.getIdByAlgorithm(idOrAlgorithm), (Object)idOrAlgorithm);
    }

    private static String getAlgorithmById(String id) {
        return (String)map.get((Object)id.toUpperCase());
    }

    private static String getIdByAlgorithm(String algorithm) {
        return (String)map.getKey((Object)algorithm);
    }
}

