/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.metric.jwt.signature;

import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.miaixz.bus.auth.metric.jwt.signature.JWTSigner;
import org.miaixz.bus.core.codec.binary.Base64;
import org.miaixz.bus.core.xyz.ByteKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.crypto.center.Sign;

public class RSAJWTSigner
implements JWTSigner {
    private final Sign sign;
    private Charset charset = org.miaixz.bus.core.lang.Charset.UTF_8;

    public RSAJWTSigner(String algorithm, Key key) {
        PublicKey publicKey = key instanceof PublicKey ? (PublicKey)key : null;
        PrivateKey privateKey = key instanceof PrivateKey ? (PrivateKey)key : null;
        this.sign = new Sign(algorithm, new KeyPair(publicKey, privateKey));
    }

    public RSAJWTSigner(String algorithm, KeyPair keyPair) {
        this.sign = new Sign(algorithm, keyPair);
    }

    public RSAJWTSigner setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    @Override
    public String sign(String headerBase64, String payloadBase64) {
        String data = StringKit.format((CharSequence)"{}.{}", (Object[])new Object[]{headerBase64, payloadBase64});
        byte[] signedData = this.sign(ByteKit.toBytes((CharSequence)data, (Charset)this.charset));
        return Base64.encodeUrlSafe((byte[])signedData);
    }

    protected byte[] sign(byte[] data) {
        return this.sign.sign(data);
    }

    @Override
    public boolean verify(String headerBase64, String payloadBase64, String signBase64) {
        byte[] data = ByteKit.toBytes((CharSequence)StringKit.format((CharSequence)"{}.{}", (Object[])new Object[]{headerBase64, payloadBase64}), (Charset)this.charset);
        byte[] signed = Base64.decode((CharSequence)signBase64);
        return this.verify(data, signed);
    }

    protected boolean verify(byte[] data, byte[] signed) {
        return this.sign.verify(data, signed);
    }

    @Override
    public String getAlgorithm() {
        return this.sign.getSignature().getAlgorithm();
    }
}

