/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Checker;
import org.miaixz.bus.auth.Complex;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Provider;
import org.miaixz.bus.auth.cache.AuthCache;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.ErrorCode;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AuthorizeScope;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.basic.entity.Message;
import org.miaixz.bus.core.data.id.ID;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.core.net.Protocol;
import org.miaixz.bus.core.net.url.UrlEncoder;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.http.Httpx;
import org.miaixz.bus.logger.Logger;

public abstract class AbstractProvider
implements Provider {
    protected Context context;
    protected Complex complex;
    protected CacheX cache;

    public AbstractProvider(Context context, Complex complex) {
        this(context, complex, AuthCache.INSTANCE);
    }

    public AbstractProvider(Context context, Complex complex, CacheX cache) {
        this.context = context;
        this.complex = complex;
        this.cache = cache;
        if (!Checker.isSupportedAuth(this.context, this.complex)) {
            throw new AuthorizedException(ErrorCode.PARAMETER_INCOMPLETE);
        }
        this.check(this.context);
    }

    public static List<String> getDefaultScopes(AuthorizeScope[] scopes) {
        if (null == scopes || scopes.length == 0) {
            return null;
        }
        return Arrays.stream(scopes).filter(AuthorizeScope::isDefault).map(AuthorizeScope::getScope).collect(Collectors.toList());
    }

    public static List<String> getScopes(AuthorizeScope ... scopes) {
        if (null == scopes || scopes.length == 0) {
            return null;
        }
        return Arrays.stream(scopes).map(AuthorizeScope::getScope).collect(Collectors.toList());
    }

    @Override
    public Message login(Callback callback) {
        try {
            this.check(callback);
            if (!this.context.isIgnoreState() && this.complex.getProtocol() == Protocol.OIDC) {
                Checker.check(callback.getState(), this.complex, this.cache);
            }
            AuthToken authToken = this.getAccessToken(callback);
            Material user = this.getUserInfo(authToken);
            return Message.builder().errcode(ErrorCode._SUCCESS.getKey()).data((Object)user).build();
        }
        catch (Exception e) {
            Logger.error((String)"Authorization login failed.", (Object[])new Object[]{e});
            return this.responseError(e);
        }
    }

    protected void check(Callback callback) {
        if (this.complex.getProtocol() == Protocol.OIDC) {
            Checker.check(this.complex, callback);
        }
    }

    protected Message responseError(Exception e) {
        String errorCode = ErrorCode._FAILURE.getKey();
        String errorMsg = e.getMessage();
        if (e instanceof AuthorizedException) {
            AuthorizedException authException = (AuthorizedException)e;
            errorCode = authException.getErrcode();
            if (StringKit.isNotEmpty((CharSequence)authException.getErrmsg())) {
                errorMsg = authException.getErrmsg();
            }
        }
        return Message.builder().errcode(errorCode).errmsg(errorMsg).build();
    }

    @Override
    public String authorize(String state) {
        if (this.complex.getProtocol() == Protocol.OIDC) {
            return Builder.fromUrl(this.complex.authorize()).queryParam("response_type", "code").queryParam("client_id", this.context.getAppKey()).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("state", this.getRealState(state)).queryParam("scope", this.getScopes(" ", true, AbstractProvider.getDefaultScopes(null))).build();
        }
        if (this.complex.getProtocol() == Protocol.SAML) {
            return Builder.fromUrl(this.complex.endpoint().get("ssoEndpoint")).queryParam("RelayState", this.getRealState(state)).build();
        }
        return null;
    }

    protected String accessTokenUrl(String code) {
        return Builder.fromUrl(this.complex.accessToken()).queryParam("code", code).queryParam("client_id", this.context.getAppKey()).queryParam("client_secret", this.context.getAppSecret()).queryParam("grant_type", "authorization_code").queryParam("redirect_uri", this.context.getRedirectUri()).build();
    }

    protected String refreshTokenUrl(String refreshToken) {
        return Builder.fromUrl(this.complex.refresh()).queryParam("client_id", this.context.getAppKey()).queryParam("client_secret", this.context.getAppSecret()).queryParam("refresh_token", refreshToken).queryParam("grant_type", "refresh_token").queryParam("redirect_uri", this.context.getRedirectUri()).build();
    }

    protected String userInfoUrl(AuthToken authToken) {
        return Builder.fromUrl(this.complex.userinfo()).queryParam("access_token", authToken.getAccessToken()).build();
    }

    protected String revokeUrl(AuthToken authToken) {
        return Builder.fromUrl(this.complex.revoke()).queryParam("access_token", authToken.getAccessToken()).build();
    }

    protected String getRealState(String state) {
        if (StringKit.isEmpty((CharSequence)state)) {
            state = ID.objectId();
        }
        this.cache.write((Object)state, (Object)state);
        return state;
    }

    protected String doPostAuthorizationCode(String code) {
        return Httpx.post((String)this.accessTokenUrl(code));
    }

    protected String doGetAuthorizationCode(String code) {
        return Httpx.get((String)this.accessTokenUrl(code));
    }

    protected String doGetUserInfo(AuthToken authToken) {
        return Httpx.get((String)this.userInfoUrl(authToken));
    }

    protected String doGetRevoke(AuthToken authToken) {
        return Httpx.get((String)this.revokeUrl(authToken));
    }

    protected String getScopes(String separator, boolean encode, List<String> defaultScopes) {
        List<String> scopes = this.context.getScopes();
        if (null == scopes || scopes.isEmpty()) {
            if (null == defaultScopes || defaultScopes.isEmpty()) {
                return "";
            }
            scopes = defaultScopes;
        }
        if (null == separator) {
            separator = " ";
        }
        String scope = String.join((CharSequence)separator, scopes);
        return encode ? UrlEncoder.encodeAll((String)scope) : scope;
    }

    protected void check(Context context) {
        if (this.complex.getProtocol() == Protocol.OIDC) {
            Checker.check(context, this.complex);
        }
    }
}

