/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.alipay;

import java.util.HashMap;
import java.util.Map;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Checker;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.ErrorCode;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.basic.entity.Message;
import org.miaixz.bus.core.lang.Gender;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.core.net.Protocol;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;

public class AlipayProvider
extends AbstractProvider {
    private static final String GATEWAY = "https://openapi.alipay.com/gateway.do";

    public AlipayProvider(Context context) {
        super(context, Registry.ALIPAY);
        this.check(context);
    }

    public AlipayProvider(Context context, CacheX cache) {
        super(context, Registry.ALIPAY, cache);
        this.check(context);
    }

    @Override
    protected void check(Context context) {
        Checker.check(context, Registry.ALIPAY);
        if (!StringKit.isNotEmpty((CharSequence)context.getUnionId())) {
            throw new AuthorizedException(ErrorCode.PARAMETER_INCOMPLETE.getKey(), new Object[]{Registry.ALIPAY});
        }
        if (Protocol.isLocalHost((String)context.getRedirectUri())) {
            throw new AuthorizedException(ErrorCode.ILLEGAL_REDIRECT_URI.getKey(), new Object[]{Registry.ALIPAY});
        }
    }

    @Override
    protected void check(Callback callback) {
        if (StringKit.isEmpty((CharSequence)callback.getAuth_code())) {
            throw new AuthorizedException(ErrorCode.ILLEGAL_CODE.getKey(), new Object[]{this.complex});
        }
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", this.context.getAppKey());
        params.put("method", "alipay.system.auth.token");
        params.put("charset", "UTF-8");
        params.put("sign_type", "RSA2");
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        params.put("version", "1.0");
        params.put("grant_type", "authorization_code");
        params.put("code", callback.getAuth_code());
        String response = Httpx.post((String)GATEWAY, params);
        Map json = JsonKit.toMap((String)response);
        Map tokenResponse = (Map)json.get("alipay_system_oauth_token_response");
        if (tokenResponse.containsKey("error_response")) {
            throw new AuthorizedException((String)((Map)tokenResponse.get("error_response")).get("sub_msg"));
        }
        return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken((String)tokenResponse.get("access_token"))).uid((String)tokenResponse.get("user_id"))).expireIn(Integer.parseInt((String)tokenResponse.get("expires_in")))).refreshToken((String)tokenResponse.get("refresh_token"))).build();
    }

    @Override
    public Message refresh(AuthToken authToken) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", this.context.getAppKey());
        params.put("method", "alipay.system.auth.token");
        params.put("charset", "UTF-8");
        params.put("sign_type", "RSA2");
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        params.put("version", "1.0");
        params.put("grant_type", "refresh_token");
        params.put("refresh_token", authToken.getRefreshToken());
        String response = Httpx.post((String)GATEWAY, params);
        Map json = JsonKit.toMap((String)response);
        Map tokenResponse = (Map)json.get("alipay_system_oauth_token_response");
        if (tokenResponse.containsKey("error_response")) {
            throw new AuthorizedException((String)((Map)tokenResponse.get("error_response")).get("sub_msg"));
        }
        return Message.builder().errcode(ErrorCode._SUCCESS.getKey()).data(((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken((String)tokenResponse.get("access_token"))).uid((String)tokenResponse.get("user_id"))).expireIn(Integer.parseInt((String)tokenResponse.get("expires_in")))).refreshToken((String)tokenResponse.get("refresh_token"))).build()).build();
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", this.context.getAppKey());
        params.put("method", "alipay.user.info.share");
        params.put("charset", "UTF-8");
        params.put("sign_type", "RSA2");
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        params.put("version", "1.0");
        params.put("auth_token", authToken.getAccessToken());
        String response = Httpx.post((String)GATEWAY, params);
        Map json = JsonKit.toMap((String)response);
        Map userResponse = (Map)json.get("alipay_user_info_share_response");
        if (userResponse.containsKey("error_response")) {
            throw new AuthorizedException((String)((Map)userResponse.get("error_response")).get("sub_msg"));
        }
        String province = (String)userResponse.get("province");
        String city = (String)userResponse.get("city");
        String location = String.format("%s %s", StringKit.isEmpty((CharSequence)province) ? "" : province, StringKit.isEmpty((CharSequence)city) ? "" : city);
        return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().rawJson(JsonKit.toJsonString((Object)userResponse))).uuid((String)userResponse.get("user_id"))).username(StringKit.isEmpty((CharSequence)((String)userResponse.get("user_name"))) ? (String)userResponse.get("nick_name") : (String)userResponse.get("user_name"))).nickname((String)userResponse.get("nick_name"))).avatar((String)userResponse.get("avatar"))).location(location)).gender(Gender.of((String)((String)userResponse.get("gender"))))).token(authToken)).source(this.complex.toString())).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(this.complex.authorize()).queryParam("app_id", this.context.getAppKey()).queryParam("scope", "auth_user").queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("state", this.getRealState(state)).build();
    }
}

