/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.amazon;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.ErrorCode;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.auth.nimble.amazon.AmazonScope;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.basic.entity.Message;
import org.miaixz.bus.core.lang.Gender;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.core.net.url.UrlEncoder;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;

public class AmazonProvider
extends AbstractProvider {
    public AmazonProvider(Context context) {
        super(context, Registry.AMAZON);
    }

    public AmazonProvider(Context context, CacheX cache) {
        super(context, Registry.AMAZON, cache);
    }

    @Override
    public String authorize(String state) {
        String realState = this.getRealState(state);
        Builder builder = Builder.fromUrl(this.complex.authorize()).queryParam("client_id", this.context.getAppKey()).queryParam("scope", this.getScopes(" ", true, AmazonProvider.getDefaultScopes(AmazonScope.values()))).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("response_type", "code").queryParam("state", realState);
        if (this.context.isPkce()) {
            String cacheKey = this.complex.getName().concat(":code_verifier:").concat(realState);
            String codeVerifier = Builder.codeVerifier();
            String codeChallengeMethod = "S256";
            String codeChallenge = Builder.codeChallenge(codeChallengeMethod, codeVerifier);
            builder.queryParam("code_challenge", codeChallenge).queryParam("code_challenge_method", codeChallengeMethod);
            this.cache.write((Object)cacheKey, (Object)codeVerifier, TimeUnit.MINUTES.toMillis(10L));
        }
        return builder.build();
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        HashMap<String, String> form = new HashMap<String, String>(9);
        form.put("grant_type", "authorization_code");
        form.put("code", callback.getCode());
        form.put("redirect_uri", this.context.getRedirectUri());
        form.put("client_id", this.context.getAppKey());
        form.put("client_secret", this.context.getAppSecret());
        if (this.context.isPkce()) {
            String cacheKey = this.complex.getName().concat(":code_verifier:").concat(callback.getState());
            String codeVerifier = String.valueOf(this.cache.read((Object)cacheKey));
            form.put("code_verifier", codeVerifier);
        }
        return this.getToken(form, this.complex.accessToken());
    }

    @Override
    public Message refresh(AuthToken authToken) {
        HashMap<String, String> form = new HashMap<String, String>(7);
        form.put("grant_type", "refresh_token");
        form.put("refresh_token", authToken.getRefreshToken());
        form.put("client_id", this.context.getAppKey());
        form.put("client_secret", this.context.getAppSecret());
        return Message.builder().errcode(ErrorCode._SUCCESS.getKey()).data((Object)this.getToken(form, this.complex.refresh())).build();
    }

    private AuthToken getToken(Map<String, String> param, String url) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Host", "api.amazon.com");
        header.put("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        String response = Httpx.post((String)url, param, header);
        try {
            Map jsonObject = (Map)JsonKit.toPojo((String)response, Map.class);
            if (jsonObject == null) {
                throw new AuthorizedException("Failed to parse JSON response: empty response");
            }
            this.checkResponse(jsonObject);
            String accessToken = (String)jsonObject.get("access_token");
            if (accessToken == null) {
                throw new AuthorizedException("Missing access_token in response");
            }
            String tokenType = (String)jsonObject.get("token_type");
            Object expiresInObj = jsonObject.get("expires_in");
            int expiresIn = expiresInObj instanceof Number ? ((Number)expiresInObj).intValue() : 0;
            String refreshToken = (String)jsonObject.get("refresh_token");
            return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken(accessToken)).tokenType(tokenType)).expireIn(expiresIn)).refreshToken(refreshToken)).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse token response: " + e.getMessage());
        }
    }

    private void checkResponse(Map<String, Object> jsonObject) {
        if (jsonObject.containsKey("error")) {
            String errorDescription = (String)jsonObject.get("error_description");
            throw new AuthorizedException(errorDescription != null ? errorDescription : "Unknown error");
        }
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        String accessToken = authToken.getAccessToken();
        this.checkToken(accessToken);
        HashMap<String, Object> header = new HashMap<String, Object>();
        header.put("Host", "api.amazon.com");
        header.put("Authorization", "bearer " + accessToken);
        String userInfo = Httpx.get((String)this.complex.userinfo(), new HashMap(0), header);
        try {
            Map jsonObject = (Map)JsonKit.toPojo((String)userInfo, Map.class);
            if (jsonObject == null) {
                throw new AuthorizedException("Failed to parse user info response: empty response");
            }
            this.checkResponse(jsonObject);
            String userId = (String)jsonObject.get("user_id");
            if (userId == null) {
                throw new AuthorizedException("Missing user_id in response");
            }
            String name = (String)jsonObject.get("name");
            String email = (String)jsonObject.get("email");
            return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().rawJson(JsonKit.toJsonString((Object)jsonObject))).uuid(userId)).username(name)).nickname(name)).email(email)).gender(Gender.UNKNOWN)).source(this.complex.toString())).token(authToken)).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse user info response: " + e.getMessage());
        }
    }

    private void checkToken(String accessToken) {
        String tokenInfo = Httpx.get((String)("https://api.amazon.com/auth/o2/tokeninfo?access_token=" + UrlEncoder.encodeAll((String)accessToken)));
        try {
            Map jsonObject = (Map)JsonKit.toPojo((String)tokenInfo, Map.class);
            if (jsonObject == null) {
                throw new AuthorizedException("Failed to parse token info response: empty response");
            }
            String aud = (String)jsonObject.get("aud");
            if (!this.context.getAppKey().equals(aud)) {
                throw new AuthorizedException(ErrorCode.ILLEGAL_TOKEN.getKey());
            }
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse token info response: " + e.getMessage());
        }
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        return Builder.fromUrl(this.complex.userinfo()).queryParam("user_id", authToken.getUserId()).queryParam("screen_name", authToken.getScreenName()).queryParam("include_entities", true).build();
    }
}

