/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.apple;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.PrivateKey;
import java.util.Base64;
import java.util.Map;
import lombok.Generated;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.cache.AuthCache;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.ErrorCode;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.auth.nimble.apple.AppleScope;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.json.JsonKit;

public class AppleProvider
extends AbstractProvider {
    private static final String AUD = "https://appleid.apple.com";
    private volatile PrivateKey privateKey;

    public AppleProvider(Context context) {
        super(context, Registry.APPLE);
    }

    public AppleProvider(Context context, AuthCache authCache) {
        super(context, Registry.APPLE, authCache);
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(super.authorize(state)).queryParam("response_mode", "form_post").queryParam("scope", this.getScopes(" ", false, AppleProvider.getDefaultScopes(AppleScope.values()))).build();
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        if (!StringKit.isEmpty((CharSequence)callback.getError())) {
            throw new AuthorizedException(callback.getError());
        }
        this.context.setAppSecret(this.getToken());
        String response = this.doPostAuthorizationCode(callback.getCode());
        try {
            Map accessTokenObject = (Map)JsonKit.toPojo((String)response, Map.class);
            if (accessTokenObject == null) {
                throw new AuthorizedException("Failed to parse access token response: empty response");
            }
            String accessToken = (String)accessTokenObject.get("access_token");
            if (accessToken == null) {
                throw new AuthorizedException("Missing access_token in response");
            }
            Object expiresInObj = accessTokenObject.get("expires_in");
            int expiresIn = expiresInObj instanceof Number ? ((Number)expiresInObj).intValue() : 0;
            String refreshToken = (String)accessTokenObject.get("refresh_token");
            String tokenType = (String)accessTokenObject.get("token_type");
            String idToken = (String)accessTokenObject.get("id_token");
            Object builder = ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken(accessToken)).expireIn(expiresIn)).refreshToken(refreshToken)).tokenType(tokenType)).idToken(idToken);
            if (!StringKit.isEmpty((CharSequence)callback.getUser())) {
                try {
                    Map nameMap;
                    Map userInfoMap = (Map)JsonKit.toPojo((String)callback.getUser(), Map.class);
                    if (userInfoMap != null && (nameMap = (Map)userInfoMap.get("name")) != null) {
                        String firstName = (String)nameMap.get("firstName");
                        String lastName = (String)nameMap.get("lastName");
                        if (firstName != null && lastName != null) {
                            ((AuthToken.AuthTokenBuilder)builder).username(firstName + " " + lastName);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return ((AuthToken.AuthTokenBuilder)builder).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse access token response: " + e.getMessage());
        }
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        Base64.Decoder urlDecoder = Base64.getUrlDecoder();
        String[] idToken = authToken.getIdToken().split("\\.");
        String payload = new String(urlDecoder.decode(idToken[1]));
        try {
            Map object = (Map)JsonKit.toPojo((String)payload, Map.class);
            if (object == null) {
                throw new AuthorizedException("Failed to parse id_token payload: empty response");
            }
            String sub = (String)object.get("sub");
            if (sub == null) {
                throw new AuthorizedException("Missing sub in id_token payload");
            }
            String email = (String)object.get("email");
            return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().rawJson(JsonKit.toJsonString((Object)object))).uuid(sub)).email(email)).username(authToken.getUsername())).token(authToken)).source(this.complex.toString())).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse id_token payload: " + e.getMessage());
        }
    }

    @Override
    protected void check(Context context) {
        super.check(context);
        if (StringKit.isEmpty((CharSequence)context.getAppKey())) {
            throw new AuthorizedException(ErrorCode.ILLEGAL_CLIENT_ID.getKey(), new Object[]{this.complex});
        }
        if (StringKit.isEmpty((CharSequence)context.getAppSecret())) {
            throw new AuthorizedException(ErrorCode.ILLEGAL_CLIENT_SECRET.getKey(), new Object[]{this.complex});
        }
        if (StringKit.isEmpty((CharSequence)context.getKid())) {
            throw new AuthorizedException(ErrorCode.ILLEGAL_KID.getKey(), new Object[]{this.complex});
        }
        if (StringKit.isEmpty((CharSequence)context.getTeamId())) {
            throw new AuthorizedException(ErrorCode.ILLEGAL_TEAM_ID.getKey(), new Object[]{this.complex});
        }
    }

    private String getToken() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrivateKey getPrivateKey() {
        if (this.privateKey == null) {
            AppleProvider appleProvider = this;
            synchronized (appleProvider) {
                if (this.privateKey == null) {
                    try (PEMParser pemParser = new PEMParser((Reader)new StringReader(this.context.getAppSecret()));){
                        JcaPEMKeyConverter pemKeyConverter = new JcaPEMKeyConverter();
                        PrivateKeyInfo keyInfo = (PrivateKeyInfo)pemParser.readObject();
                        this.privateKey = pemKeyConverter.getPrivateKey(keyInfo);
                    }
                    catch (IOException e) {
                        throw new AuthorizedException("Failed to get apple private key", (Throwable)e);
                    }
                }
            }
        }
        return this.privateKey;
    }

    static class AppleUsername {
        private String firstName;
        private String lastName;

        @Generated
        public AppleUsername() {
        }

        @Generated
        public String getFirstName() {
            return this.firstName;
        }

        @Generated
        public String getLastName() {
            return this.lastName;
        }

        @Generated
        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Generated
        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AppleUsername)) {
                return false;
            }
            AppleUsername other = (AppleUsername)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$firstName = this.getFirstName();
            String other$firstName = other.getFirstName();
            if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
                return false;
            }
            String this$lastName = this.getLastName();
            String other$lastName = other.getLastName();
            return !(this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AppleUsername;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $firstName = this.getFirstName();
            result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
            String $lastName = this.getLastName();
            result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AppleProvider.AppleUsername(firstName=" + this.getFirstName() + ", lastName=" + this.getLastName() + ")";
        }
    }

    static class AppleUserInfo {
        private AppleUsername name;
        private String email;

        @Generated
        public AppleUserInfo() {
        }

        @Generated
        public AppleUsername getName() {
            return this.name;
        }

        @Generated
        public String getEmail() {
            return this.email;
        }

        @Generated
        public void setName(AppleUsername name) {
            this.name = name;
        }

        @Generated
        public void setEmail(String email) {
            this.email = email;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AppleUserInfo)) {
                return false;
            }
            AppleUserInfo other = (AppleUserInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AppleUsername this$name = this.getName();
            AppleUsername other$name = other.getName();
            if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
                return false;
            }
            String this$email = this.getEmail();
            String other$email = other.getEmail();
            return !(this$email == null ? other$email != null : !this$email.equals(other$email));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AppleUserInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AppleUsername $name = this.getName();
            result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
            String $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AppleProvider.AppleUserInfo(name=" + String.valueOf(this.getName()) + ", email=" + this.getEmail() + ")";
        }
    }
}

