/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.baidu;

import java.util.Map;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.ErrorCode;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.auth.nimble.baidu.BaiduScope;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.basic.entity.Message;
import org.miaixz.bus.core.basic.normal.Errors;
import org.miaixz.bus.core.lang.Gender;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;

public class BaiduProvider
extends AbstractProvider {
    public BaiduProvider(Context context) {
        super(context, Registry.BAIDU);
    }

    public BaiduProvider(Context context, CacheX cache) {
        super(context, Registry.BAIDU, cache);
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        String response = this.doPostAuthorizationCode(callback.getCode());
        return this.getAuthToken(response);
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        String userInfo = this.doGetUserInfo(authToken);
        try {
            String userId;
            Map object = (Map)JsonKit.toPojo((String)userInfo, Map.class);
            if (object == null) {
                throw new AuthorizedException("Failed to parse user info response: empty response");
            }
            this.checkResponse(object);
            String string = userId = object.containsKey("userid") ? (String)object.get("userid") : (String)object.get("openid");
            if (userId == null) {
                throw new AuthorizedException("Missing userid or openid in response");
            }
            String username = (String)object.get("username");
            String userDetail = (String)object.get("userdetail");
            String sex = (String)object.get("sex");
            return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().rawJson(JsonKit.toJsonString((Object)object))).uuid(userId)).username(username)).nickname(username)).avatar(this.getAvatar(object))).remark(userDetail)).gender(Gender.of((String)sex))).token(authToken)).source(this.complex.toString())).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse user info response: " + e.getMessage());
        }
    }

    private String getAvatar(Map<String, Object> object) {
        String portrait = (String)object.get("portrait");
        return StringKit.isEmpty((CharSequence)portrait) ? null : String.format("http://himg.bdimg.com/sys/portrait/item/%s.jpg", portrait);
    }

    @Override
    public Message revoke(AuthToken authToken) {
        String response = this.doGetRevoke(authToken);
        try {
            Map object = (Map)JsonKit.toPojo((String)response, Map.class);
            if (object == null) {
                throw new AuthorizedException("Failed to parse revoke response: empty response");
            }
            this.checkResponse(object);
            Object resultObj = object.get("result");
            int result = resultObj instanceof Number ? ((Number)resultObj).intValue() : 0;
            Errors status = result == 1 ? ErrorCode._SUCCESS : ErrorCode._FAILURE;
            return Message.builder().errcode(status.getKey()).errmsg(status.getValue()).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse revoke response: " + e.getMessage());
        }
    }

    @Override
    public Message refresh(AuthToken authToken) {
        String refreshUrl = Builder.fromUrl(this.complex.refresh()).queryParam("grant_type", "refresh_token").queryParam("refresh_token", authToken.getRefreshToken()).queryParam("client_id", this.context.getAppKey()).queryParam("client_secret", this.context.getAppSecret()).build();
        String response = Httpx.get((String)refreshUrl);
        return Message.builder().errcode(ErrorCode._SUCCESS.getKey()).data((Object)this.getAuthToken(response)).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(super.authorize(state)).queryParam("display", "popup").queryParam("scope", this.getScopes(" ", true, BaiduProvider.getDefaultScopes(BaiduScope.values()))).build();
    }

    private void checkResponse(Map<String, Object> object) {
        if (object.containsKey("error") || object.containsKey("error_code")) {
            String msg = object.containsKey("error_description") ? (String)object.get("error_description") : (String)object.get("error_msg");
            throw new AuthorizedException(msg != null ? msg : "Unknown error");
        }
    }

    private AuthToken getAuthToken(String response) {
        try {
            Map accessTokenObject = (Map)JsonKit.toPojo((String)response, Map.class);
            if (accessTokenObject == null) {
                throw new AuthorizedException("Failed to parse access token response: empty response");
            }
            this.checkResponse(accessTokenObject);
            String accessToken = (String)accessTokenObject.get("access_token");
            if (accessToken == null) {
                throw new AuthorizedException("Missing access_token in response");
            }
            String refreshToken = (String)accessTokenObject.get("refresh_token");
            String scope = (String)accessTokenObject.get("scope");
            Object expiresInObj = accessTokenObject.get("expires_in");
            int expiresIn = expiresInObj instanceof Number ? ((Number)expiresInObj).intValue() : 0;
            return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken(accessToken)).refreshToken(refreshToken)).scope(scope)).expireIn(expiresIn)).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse access token response: " + e.getMessage());
        }
    }
}

