/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.coding;

import java.util.Map;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.auth.nimble.coding.CodingScope;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.lang.Gender;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.extra.json.JsonKit;

public class CodingProvider
extends AbstractProvider {
    public CodingProvider(Context context) {
        super(context, Registry.CODING);
    }

    public CodingProvider(Context context, CacheX cache) {
        super(context, Registry.CODING, cache);
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        String response = this.doPostAuthorizationCode(callback.getCode());
        try {
            Map accessTokenObject = (Map)JsonKit.toPojo((String)response, Map.class);
            if (accessTokenObject == null) {
                throw new AuthorizedException("Failed to parse access token response: empty response");
            }
            this.checkResponse(accessTokenObject);
            String accessToken = (String)accessTokenObject.get("access_token");
            if (accessToken == null) {
                throw new AuthorizedException("Missing access_token in response");
            }
            Object expiresInObj = accessTokenObject.get("expires_in");
            int expiresIn = expiresInObj instanceof Number ? ((Number)expiresInObj).intValue() : 0;
            String refreshToken = (String)accessTokenObject.get("refresh_token");
            return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken(accessToken)).expireIn(expiresIn)).refreshToken(refreshToken)).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse access token response: " + e.getMessage());
        }
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        String response = this.doGetUserInfo(authToken);
        try {
            Map object = (Map)JsonKit.toPojo((String)response, Map.class);
            if (object == null) {
                throw new AuthorizedException("Failed to parse user info response: empty response");
            }
            this.checkResponse(object);
            Map data = (Map)object.get("data");
            if (data == null) {
                throw new AuthorizedException("Missing data field in user info response");
            }
            String id = String.valueOf(data.get("id"));
            if (id == null) {
                throw new AuthorizedException("Missing id in user info response");
            }
            String name = (String)data.get("name");
            String avatar = (String)data.get("avatar");
            String path = (String)data.get("path");
            String company = (String)data.get("company");
            String location = (String)data.get("location");
            String sex = (String)data.get("sex");
            String email = (String)data.get("email");
            String slogan = (String)data.get("slogan");
            return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().rawJson(JsonKit.toJsonString((Object)data))).uuid(id)).username(name)).avatar(avatar != null ? "https://coding.net" + avatar : null)).blog(path != null ? "https://coding.net" + path : null)).nickname(name)).company(company)).location(location)).gender(Gender.of((String)sex))).email(email)).remark(slogan)).token(authToken)).source(this.complex.toString())).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse user info response: " + e.getMessage());
        }
    }

    private void checkResponse(Map<String, Object> object) {
        if ((Integer)object.get("code") != 0) {
            throw new AuthorizedException((String)object.get("msg"));
        }
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(String.format(this.complex.authorize(), this.context.getPrefix())).queryParam("response_type", "code").queryParam("client_id", this.context.getAppKey()).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("scope", this.getScopes(" ", true, CodingProvider.getDefaultScopes(CodingScope.values()))).queryParam("state", this.getRealState(state)).build();
    }

    @Override
    public String accessTokenUrl(String code) {
        return Builder.fromUrl(String.format(this.complex.accessToken(), this.context.getPrefix())).queryParam("code", code).queryParam("client_id", this.context.getAppKey()).queryParam("client_secret", this.context.getAppSecret()).queryParam("grant_type", "authorization_code").queryParam("redirect_uri", this.context.getRedirectUri()).build();
    }

    @Override
    public String userInfoUrl(AuthToken authToken) {
        return Builder.fromUrl(String.format(this.complex.userinfo(), this.context.getPrefix())).queryParam("access_token", authToken.getAccessToken()).build();
    }
}

