/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.dingtalk;

import java.util.HashMap;
import java.util.Map;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Complex;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.codec.binary.Base64;
import org.miaixz.bus.core.lang.Algorithm;
import org.miaixz.bus.core.lang.Charset;
import org.miaixz.bus.core.lang.Gender;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.core.net.url.UrlEncoder;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;

public abstract class AbstractDingtalkProvider
extends AbstractProvider {
    public AbstractDingtalkProvider(Context context, Complex complex) {
        super(context, complex);
    }

    public AbstractDingtalkProvider(Context context, Complex complex, CacheX cache) {
        super(context, complex, cache);
    }

    public static String sign(String secretKey, String timestamp) {
        byte[] signData = Builder.sign(secretKey.getBytes(Charset.UTF_8), timestamp.getBytes(Charset.UTF_8), Algorithm.HMACSHA256.getValue());
        return UrlEncoder.encodeAll((String)new String(Base64.encode((byte[])signData, (boolean)false)));
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        return ((AuthToken.AuthTokenBuilder)AuthToken.builder().accessCode(callback.getCode())).build();
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        String code = authToken.getAccessCode();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tmp_auth_code", code);
        String response = Httpx.post((String)this.userInfoUrl(authToken), (String)JsonKit.toJsonString(param), (String)"application/json");
        try {
            int errCode;
            Map object = (Map)JsonKit.toPojo((String)response, Map.class);
            if (object == null) {
                throw new AuthorizedException("Failed to parse user info response: empty response");
            }
            Object errCodeObj = object.get("errcode");
            int n = errCode = errCodeObj instanceof Number ? ((Number)errCodeObj).intValue() : -1;
            if (errCode != 0) {
                String errMsg = (String)object.get("errmsg");
                throw new AuthorizedException(errMsg != null ? errMsg : "Unknown error");
            }
            Map userInfo = (Map)object.get("user_info");
            if (userInfo == null) {
                throw new AuthorizedException("Missing user_info in response");
            }
            String openId = (String)userInfo.get("openid");
            String unionId = (String)userInfo.get("unionid");
            if (unionId == null) {
                throw new AuthorizedException("Missing unionid in user_info");
            }
            String nick = (String)userInfo.get("nick");
            Object token = ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().openId(openId)).unionId(unionId)).build();
            return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().rawJson(JsonKit.toJsonString((Object)userInfo))).uuid(unionId)).nickname(nick)).username(nick)).gender(Gender.UNKNOWN)).source(this.complex.toString())).token((AuthToken)token)).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse user info response: " + e.getMessage());
        }
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(this.complex.authorize()).queryParam("response_type", "code").queryParam("appid", this.context.getAppKey()).queryParam("scope", "snsapi_login").queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("state", this.getRealState(state)).build();
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        String timestamp = "" + System.currentTimeMillis();
        String urlEncodeSignature = AbstractDingtalkProvider.sign(this.context.getAppSecret(), timestamp);
        return Builder.fromUrl(this.complex.userinfo()).queryParam("signature", urlEncodeSignature).queryParam("timestamp", timestamp).queryParam("accessKey", this.context.getAppKey()).build();
    }
}

