/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.dingtalk;

import java.util.HashMap;
import java.util.Map;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.dingtalk.AbstractDingtalkProvider;
import org.miaixz.bus.auth.nimble.dingtalk.DingTalkScope;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;

public class DingTalkProvider
extends AbstractDingtalkProvider {
    public DingTalkProvider(Context context) {
        super(context, Registry.DINGTALK);
    }

    public DingTalkProvider(Context context, CacheX cache) {
        super(context, Registry.DINGTALK, cache);
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(this.complex.authorize()).queryParam("response_type", "code").queryParam("client_id", this.context.getAppKey()).queryParam("scope", this.getScopes(",", true, DingTalkProvider.getDefaultScopes(DingTalkScope.values()))).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("prompt", "consent").queryParam("org_type", this.context.getType()).queryParam("corpId", this.context.getUnionId()).queryParam("exclusiveLogin", this.context.getLoginType()).queryParam("exclusiveCorpId", this.context.getExtId()).queryParam("state", this.getRealState(state)).build();
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("grantType", "authorization_code");
        params.put("clientId", this.context.getAppKey());
        params.put("clientSecret", this.context.getAppSecret());
        params.put("code", callback.getCode());
        String response = Httpx.get((String)this.complex.accessToken(), (String)JsonKit.toJsonString(params));
        try {
            Map accessTokenObject = (Map)JsonKit.toPojo((String)response, Map.class);
            if (accessTokenObject == null) {
                throw new AuthorizedException("Failed to parse access token response: empty response");
            }
            if (!accessTokenObject.containsKey("accessToken")) {
                throw new AuthorizedException("Missing accessToken in response: " + JsonKit.toJsonString((Object)accessTokenObject));
            }
            String accessToken = (String)accessTokenObject.get("accessToken");
            String refreshToken = (String)accessTokenObject.get("refreshToken");
            Object expireInObj = accessTokenObject.get("expireIn");
            int expireIn = expireInObj instanceof Number ? ((Number)expireInObj).intValue() : 0;
            String corpId = (String)accessTokenObject.get("corpId");
            return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken(accessToken)).refreshToken(refreshToken)).expireIn(expireIn)).unionId(corpId)).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse access token response: " + e.getMessage());
        }
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("x-acs-dingtalk-access-token", authToken.getAccessToken());
        String response = Httpx.get((String)this.complex.userinfo(), new HashMap(0), header);
        try {
            Map object = (Map)JsonKit.toPojo((String)response, Map.class);
            if (object == null) {
                throw new AuthorizedException("Failed to parse user info response: empty response");
            }
            String openId = (String)object.get("openId");
            String unionId = (String)object.get("unionId");
            if (unionId == null) {
                throw new AuthorizedException("Missing unionId in user info response");
            }
            String nick = (String)object.get("nick");
            String avatarUrl = (String)object.get("avatarUrl");
            Object visitorObj = object.get("visitor");
            boolean visitor = visitorObj instanceof Boolean ? (Boolean)visitorObj : false;
            authToken.setOpenId(openId);
            authToken.setUnionId(unionId);
            return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().rawJson(JsonKit.toJsonString((Object)object))).uuid(unionId)).username(nick)).nickname(nick)).avatar(avatarUrl)).snapshotUser(visitor)).token(authToken)).source(this.complex.toString())).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse user info response: " + e.getMessage());
        }
    }

    @Override
    protected String accessTokenUrl(String code) {
        return Builder.fromUrl(this.complex.accessToken()).queryParam("code", code).queryParam("clientId", this.context.getAppKey()).queryParam("clientSecret", this.context.getAppSecret()).queryParam("grantType", "authorization_code").build();
    }
}

