/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.douyin;

import java.util.Map;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;

public class DouyinMiniProvider
extends AbstractProvider {
    public DouyinMiniProvider(Context context) {
        super(context, Registry.DOUYIN_MINI);
    }

    public DouyinMiniProvider(Context context, CacheX cache) {
        super(context, Registry.DOUYIN_MINI, cache);
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        String response = Httpx.get((String)this.accessTokenUrl(callback.getCode(), callback.getAnonymous_code()));
        Map accessTokenObject = (Map)JsonKit.toPojo((String)response, Map.class);
        this.checkResponse(accessTokenObject);
        return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().openId((String)accessTokenObject.get("openid"))).unionId((String)accessTokenObject.get("unionid"))).accessToken((String)accessTokenObject.get("session_key"))).build();
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().username("")).nickname("")).avatar("")).uuid(authToken.getOpenId())).token(authToken)).source(this.complex.toString())).build();
    }

    private String accessTokenUrl(String code, String anonymousCode) {
        return Builder.fromUrl(this.complex.accessToken()).queryParam("appid", this.context.getAppKey()).queryParam("secret", this.context.getAppSecret()).queryParam("code", code).queryParam("anonymous_code", anonymousCode).build();
    }

    private AuthToken getToken(String accessTokenUrl) {
        String response = Httpx.get((String)accessTokenUrl);
        try {
            Map object = (Map)JsonKit.toPojo((String)response, Map.class);
            if (object == null) {
                throw new AuthorizedException("Failed to parse token response: empty response");
            }
            this.checkResponse(object);
            Map dataObj = (Map)object.get("data");
            if (dataObj == null) {
                throw new AuthorizedException("Missing data field in token response");
            }
            String accessToken = (String)dataObj.get("access_token");
            if (accessToken == null) {
                throw new AuthorizedException("Missing access_token in response");
            }
            String openId = (String)dataObj.get("anonymousOpenid");
            Object expiresInObj = dataObj.get("expires_in");
            String unionId = dataObj.get("unionId").toString();
            int expiresIn = expiresInObj instanceof Number ? ((Number)expiresInObj).intValue() : 0;
            String refreshToken = (String)dataObj.get("refresh_token");
            Object refreshExpiresInObj = dataObj.get("refresh_expires_in");
            int refreshExpiresIn = refreshExpiresInObj instanceof Number ? ((Number)refreshExpiresInObj).intValue() : 0;
            String scope = (String)dataObj.get("scope");
            return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken(accessToken)).openId(openId)).expireIn(expiresIn)).unionId(unionId)).refreshToken(refreshToken)).refreshTokenExpireIn(refreshExpiresIn)).scope(scope)).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse token response: " + e.getMessage());
        }
    }

    private void checkResponse(Map<String, Object> object) {
        String errorCode;
        String message = (String)object.get("message");
        Map data = (Map)object.get("data");
        if (data == null) {
            throw new AuthorizedException("Missing data field in response");
        }
        Object errorCodeObj = data.get("error_code");
        String string = errorCode = errorCodeObj != null ? String.valueOf(errorCodeObj) : null;
        if ("error".equals(message) || !"0".equals(errorCode)) {
            String description = (String)data.get("description");
            throw new AuthorizedException(errorCode, description != null ? description : "Unknown error");
        }
    }
}

