/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.douyin;

import java.util.Map;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.ErrorCode;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.auth.nimble.douyin.DouyinScope;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.basic.entity.Message;
import org.miaixz.bus.core.lang.Gender;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;

public class DouyinProvider
extends AbstractProvider {
    public DouyinProvider(Context context) {
        super(context, Registry.DOUYIN);
    }

    public DouyinProvider(Context context, CacheX cache) {
        super(context, Registry.DOUYIN, cache);
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        return this.getToken(this.accessTokenUrl(callback.getCode()));
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        String response = this.doGetUserInfo(authToken);
        try {
            Map userInfoObject = (Map)JsonKit.toPojo((String)response, Map.class);
            if (userInfoObject == null) {
                throw new AuthorizedException("Failed to parse user info response: empty response");
            }
            this.checkResponse(userInfoObject);
            Map data = (Map)userInfoObject.get("data");
            if (data == null) {
                throw new AuthorizedException("Missing data field in user info response");
            }
            String unionId = (String)data.get("union_id");
            if (unionId == null) {
                throw new AuthorizedException("Missing union_id in user info response");
            }
            String nickname = (String)data.get("nickname");
            String avatar = (String)data.get("avatar");
            String description = (String)data.get("description");
            String gender = (String)data.get("gender");
            String country = (String)data.get("country");
            String province = (String)data.get("province");
            String city = (String)data.get("city");
            authToken.setUnionId(unionId);
            return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().rawJson(JsonKit.toJsonString((Object)data))).uuid(unionId)).username(nickname)).nickname(nickname)).avatar(avatar)).remark(description)).gender(Gender.of((String)gender))).location(String.format("%s %s %s", country, province, city))).token(authToken)).source(this.complex.toString())).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse user info response: " + e.getMessage());
        }
    }

    @Override
    public Message refresh(AuthToken authToken) {
        return Message.builder().errcode(ErrorCode._SUCCESS.getKey()).data((Object)this.getToken(this.refreshTokenUrl(authToken.getRefreshToken()))).build();
    }

    private void checkResponse(Map<String, Object> object) {
        String errorCode;
        String message = (String)object.get("message");
        Map data = (Map)object.get("data");
        if (data == null) {
            throw new AuthorizedException("Missing data field in response");
        }
        Object errorCodeObj = data.get("error_code");
        String string = errorCode = errorCodeObj != null ? String.valueOf(errorCodeObj) : null;
        if ("error".equals(message) || !"0".equals(errorCode)) {
            String description = (String)data.get("description");
            throw new AuthorizedException(errorCode, description != null ? description : "Unknown error");
        }
    }

    private AuthToken getToken(String accessTokenUrl) {
        String response = Httpx.post((String)accessTokenUrl);
        try {
            Map object = (Map)JsonKit.toPojo((String)response, Map.class);
            if (object == null) {
                throw new AuthorizedException("Failed to parse token response: empty response");
            }
            this.checkResponse(object);
            Map dataObj = (Map)object.get("data");
            if (dataObj == null) {
                throw new AuthorizedException("Missing data field in token response");
            }
            String accessToken = (String)dataObj.get("access_token");
            if (accessToken == null) {
                throw new AuthorizedException("Missing access_token in response");
            }
            String openId = (String)dataObj.get("open_id");
            Object expiresInObj = dataObj.get("expires_in");
            int expiresIn = expiresInObj instanceof Number ? ((Number)expiresInObj).intValue() : 0;
            String refreshToken = (String)dataObj.get("refresh_token");
            Object refreshExpiresInObj = dataObj.get("refresh_expires_in");
            int refreshExpiresIn = refreshExpiresInObj instanceof Number ? ((Number)refreshExpiresInObj).intValue() : 0;
            String scope = (String)dataObj.get("scope");
            return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken(accessToken)).openId(openId)).expireIn(expiresIn)).refreshToken(refreshToken)).refreshTokenExpireIn(refreshExpiresIn)).scope(scope)).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse token response: " + e.getMessage());
        }
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(this.complex.authorize()).queryParam("response_type", "code").queryParam("client_key", this.context.getAppKey()).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("scope", this.getScopes(",", true, DouyinProvider.getDefaultScopes(DouyinScope.values()))).queryParam("state", this.getRealState(state)).build();
    }

    @Override
    protected String accessTokenUrl(String code) {
        return Builder.fromUrl(this.complex.accessToken()).queryParam("code", code).queryParam("client_key", this.context.getAppKey()).queryParam("client_secret", this.context.getAppSecret()).queryParam("grant_type", "authorization_code").queryParam("redirect_uri", this.context.getRedirectUri()).build();
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        return Builder.fromUrl(this.complex.userinfo()).queryParam("access_token", authToken.getAccessToken()).queryParam("open_id", authToken.getOpenId()).build();
    }

    @Override
    protected String refreshTokenUrl(String refreshToken) {
        return Builder.fromUrl(this.complex.refresh()).queryParam("client_key", this.context.getAppKey()).queryParam("refresh_token", refreshToken).queryParam("grant_type", "refresh_token").build();
    }
}

