/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.eleme;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.ErrorCode;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.basic.entity.Message;
import org.miaixz.bus.core.codec.binary.Base64;
import org.miaixz.bus.core.data.id.ID;
import org.miaixz.bus.core.lang.Gender;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;

public class ElemeProvider
extends AbstractProvider {
    public ElemeProvider(Context context) {
        super(context, Registry.ELEME);
    }

    public ElemeProvider(Context context, CacheX cache) {
        super(context, Registry.ELEME, cache);
    }

    public static String sign(String appKey, String secret, long timestamp, String action, String token, Map<String, Object> parameters) {
        TreeMap<String, Object> sorted = new TreeMap<String, Object>(parameters);
        sorted.put("app_key", appKey);
        sorted.put("timestamp", timestamp);
        StringBuffer string = new StringBuffer();
        for (Map.Entry entry : sorted.entrySet()) {
            string.append((String)entry.getKey()).append("=").append(JsonKit.toJsonString(entry.getValue()));
        }
        String splice = String.format("%s%s%s%s", action, token, string, secret);
        String calculatedSignature = org.miaixz.bus.crypto.Builder.md5Hex((String)splice);
        return calculatedSignature.toUpperCase();
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        HashMap<String, String> form = new HashMap<String, String>(7);
        form.put("client_id", this.context.getAppKey());
        form.put("redirect_uri", this.context.getRedirectUri());
        form.put("code", callback.getCode());
        form.put("grant_type", "authorization_code");
        Map<String, String> header = this.buildHeader("application/x-www-form-urlencoded", this.getRequestId(), true);
        String response = Httpx.post((String)this.complex.accessToken(), form, header);
        try {
            Map object = (Map)JsonKit.toPojo((String)response, Map.class);
            if (object == null) {
                throw new AuthorizedException("Failed to parse access token response: empty response");
            }
            this.checkResponse(object);
            String accessToken = (String)object.get("access_token");
            if (accessToken == null) {
                throw new AuthorizedException("Missing access_token in response");
            }
            String refreshToken = (String)object.get("refresh_token");
            String tokenType = (String)object.get("token_type");
            Object expiresInObj = object.get("expires_in");
            int expiresIn = expiresInObj instanceof Number ? ((Number)expiresInObj).intValue() : 0;
            return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken(accessToken)).refreshToken(refreshToken)).tokenType(tokenType)).expireIn(expiresIn)).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse access token response: " + e.getMessage());
        }
    }

    @Override
    public Message refresh(AuthToken authToken) {
        HashMap<String, String> form = new HashMap<String, String>(4);
        form.put("refresh_token", authToken.getRefreshToken());
        form.put("grant_type", "refresh_token");
        Map<String, String> header = this.buildHeader("application/x-www-form-urlencoded", this.getRequestId(), true);
        String response = Httpx.post((String)this.complex.refresh(), form, header);
        try {
            Map object = (Map)JsonKit.toPojo((String)response, Map.class);
            if (object == null) {
                throw new AuthorizedException("Failed to parse refresh token response: empty response");
            }
            this.checkResponse(object);
            String accessToken = (String)object.get("access_token");
            if (accessToken == null) {
                throw new AuthorizedException("Missing access_token in response");
            }
            String refreshToken = (String)object.get("refresh_token");
            String tokenType = (String)object.get("token_type");
            Object expiresInObj = object.get("expires_in");
            int expiresIn = expiresInObj instanceof Number ? ((Number)expiresInObj).intValue() : 0;
            return Message.builder().errcode(ErrorCode._SUCCESS.getKey()).data(((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken(accessToken)).refreshToken(refreshToken)).tokenType(tokenType)).expireIn(expiresIn)).build()).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse refresh token response: " + e.getMessage());
        }
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(4);
        String action = "eleme.user.getUser";
        long timestamp = System.currentTimeMillis();
        HashMap<String, Object> metasHashMap = new HashMap<String, Object>(4);
        metasHashMap.put("app_key", this.context.getAppKey());
        metasHashMap.put("timestamp", timestamp);
        String signature = ElemeProvider.sign(this.context.getAppKey(), this.context.getAppSecret(), timestamp, action, authToken.getAccessToken(), parameters);
        String requestId = this.getRequestId();
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("nop", "1.0.0");
        paramsMap.put("id", requestId);
        paramsMap.put("action", action);
        paramsMap.put("token", authToken.getAccessToken());
        paramsMap.put("metas", metasHashMap);
        paramsMap.put("params", parameters);
        paramsMap.put("signature", signature);
        Map<String, String> header = this.buildHeader("application/json", requestId, false);
        String response = Httpx.post((String)this.complex.userinfo(), (String)JsonKit.toJsonString(paramsMap), header, (String)"application/json");
        try {
            Map object = (Map)JsonKit.toPojo((String)response, Map.class);
            if (object == null) {
                throw new AuthorizedException("Failed to parse user info response: empty response");
            }
            if (object.containsKey("name")) {
                String message = (String)object.get("message");
                throw new AuthorizedException(message != null ? message : "Unknown error");
            }
            if (object.containsKey("error") && object.get("error") != null) {
                Map error = (Map)object.get("error");
                String errorMessage = (String)error.get("message");
                throw new AuthorizedException(errorMessage != null ? errorMessage : "Unknown error");
            }
            Map result = (Map)object.get("result");
            if (result == null) {
                throw new AuthorizedException("Missing result field in user info response");
            }
            String userId = (String)result.get("userId");
            if (userId == null) {
                throw new AuthorizedException("Missing userId in user info response");
            }
            String userName = (String)result.get("userName");
            return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().rawJson(JsonKit.toJsonString((Object)result))).uuid(userId)).username(userName)).nickname(userName)).gender(Gender.UNKNOWN)).token(authToken)).source(this.complex.toString())).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse user info response: " + e.getMessage());
        }
    }

    private String getBasic(String appKey, String appSecret) {
        StringBuilder sb = new StringBuilder();
        String encodeToString = Base64.encode((byte[])(appKey + ":" + appSecret).getBytes());
        sb.append("Basic").append(" ").append(encodeToString);
        return sb.toString();
    }

    private Map<String, String> buildHeader(String contentType, String requestId, boolean auth) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Accept", "text/xml,text/javascript,text/html");
        header.put("Content-Type", contentType);
        header.put("Accept-Encoding", "gzip");
        header.put("User-Agent", "eleme-openapi-java-sdk");
        header.put("x-eleme-requestid", requestId);
        if (auth) {
            header.put("Authorization", this.getBasic(this.context.getAppKey(), this.context.getAppSecret()));
        }
        return header;
    }

    private String getRequestId() {
        return (ID.objectId() + "|" + System.currentTimeMillis()).toUpperCase();
    }

    private void checkResponse(Map<String, Object> object) {
        if (object.containsKey("error")) {
            String errorDescription = (String)object.get("error_description");
            throw new AuthorizedException(errorDescription != null ? errorDescription : "Unknown error");
        }
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(super.authorize(state)).queryParam("scope", "all").build();
    }
}

