/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.feishu;

import java.util.HashMap;
import java.util.Map;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.ErrorCode;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.basic.entity.Message;
import org.miaixz.bus.core.lang.Gender;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.core.net.url.UrlEncoder;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;

public class FeishuProvider
extends AbstractProvider {
    public FeishuProvider(Context context) {
        super(context, Registry.FEISHU);
    }

    public FeishuProvider(Context context, CacheX cache) {
        super(context, Registry.FEISHU, cache);
    }

    private String getAppAccessToken() {
        String cacheKey = this.complex.getName().concat(":app_access_token:").concat(this.context.getAppKey());
        String cacheAppAccessToken = String.valueOf(this.cache.read((Object)cacheKey));
        if (StringKit.isNotEmpty((CharSequence)cacheAppAccessToken)) {
            return cacheAppAccessToken;
        }
        String url = "https://open.feishu.cn/open-apis/auth/v3/app_access_token/internal/";
        HashMap<String, String> requestObject = new HashMap<String, String>();
        requestObject.put("app_id", this.context.getAppKey());
        requestObject.put("app_secret", this.context.getAppSecret());
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        String response = Httpx.post((String)url, (String)JsonKit.toJsonString(requestObject), header, (String)"application/json");
        Map jsonObject = (Map)JsonKit.toPojo((String)response, Map.class);
        if (jsonObject == null) {
            throw new AuthorizedException("Failed to parse app access token response: empty response");
        }
        this.checkResponse(jsonObject);
        String appAccessToken = (String)jsonObject.get("app_access_token");
        if (appAccessToken == null) {
            throw new AuthorizedException("Missing app_access_token in response");
        }
        Object expireObj = jsonObject.get("expire");
        long expire = expireObj instanceof Number ? ((Number)expireObj).longValue() : 0L;
        this.cache.write((Object)cacheKey, (Object)appAccessToken, expire * 1000L);
        return appAccessToken;
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        HashMap<String, Object> requestObject = new HashMap<String, Object>();
        requestObject.put("app_access_token", this.getAppAccessToken());
        requestObject.put("grant_type", "authorization_code");
        requestObject.put("code", callback.getCode());
        return this.getToken(requestObject, this.complex.accessToken());
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        String accessToken = authToken.getAccessToken();
        HashMap<String, Object> header = new HashMap<String, Object>();
        header.put("Content-Type", "application/json");
        header.put("Authorization", "Bearer " + accessToken);
        String response = Httpx.get((String)this.complex.userinfo(), null, header);
        try {
            Map object = (Map)JsonKit.toPojo((String)response, Map.class);
            if (object == null) {
                throw new AuthorizedException("Failed to parse user info response: empty response");
            }
            this.checkResponse(object);
            Map data = (Map)object.get("data");
            if (data == null) {
                throw new AuthorizedException("Missing data in user info response");
            }
            String unionId = (String)data.get("union_id");
            String name = (String)data.get("name");
            String avatarUrl = (String)data.get("avatar_url");
            String email = (String)data.get("email");
            return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().rawJson(JsonKit.toJsonString((Object)object))).uuid(unionId)).username(name)).nickname(name)).avatar(avatarUrl)).email(email)).gender(Gender.UNKNOWN)).token(authToken)).source(this.complex.toString())).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse user info response: " + e.getMessage());
        }
    }

    @Override
    public Message refresh(AuthToken authToken) {
        HashMap<String, Object> requestObject = new HashMap<String, Object>();
        requestObject.put("app_access_token", this.getAppAccessToken());
        requestObject.put("grant_type", "refresh_token");
        requestObject.put("refresh_token", authToken.getRefreshToken());
        return Message.builder().errcode(ErrorCode._SUCCESS.getKey()).data((Object)this.getToken(requestObject, this.complex.refresh())).build();
    }

    private AuthToken getToken(Map<String, Object> param, String url) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        String response = Httpx.post((String)url, (String)JsonKit.toJsonString(param), header, (String)"application/json");
        try {
            Map jsonObject = (Map)JsonKit.toPojo((String)response, Map.class);
            if (jsonObject == null) {
                throw new AuthorizedException("Failed to parse token response: empty response");
            }
            this.checkResponse(jsonObject);
            Map data = (Map)jsonObject.get("data");
            if (data == null) {
                throw new AuthorizedException("Missing data in token response");
            }
            String accessToken = (String)data.get("access_token");
            if (accessToken == null) {
                throw new AuthorizedException("Missing access_token in response");
            }
            String refreshToken = (String)data.get("refresh_token");
            Object expiresInObj = data.get("expires_in");
            int expiresIn = expiresInObj instanceof Number ? ((Number)expiresInObj).intValue() : 0;
            String tokenType = (String)data.get("token_type");
            String openId = (String)data.get("open_id");
            return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken(accessToken)).refreshToken(refreshToken)).expireIn(expiresIn)).tokenType(tokenType)).openId(openId)).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse token response: " + e.getMessage());
        }
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(this.complex.authorize()).queryParam("app_id", this.context.getAppKey()).queryParam("redirect_uri", UrlEncoder.encodeAll((String)this.context.getRedirectUri())).queryParam("state", this.getRealState(state)).build();
    }

    private void checkResponse(Map<String, Object> jsonObject) {
        int code;
        Object codeObj = jsonObject.get("code");
        int n = code = codeObj instanceof Number ? ((Number)codeObj).intValue() : -1;
        if (code != 0) {
            String message = (String)jsonObject.get("message");
            throw new AuthorizedException(message != null ? message : "Unknown error");
        }
    }
}

