/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.figma;

import java.util.HashMap;
import java.util.Map;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.ErrorCode;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.auth.nimble.figma.FigmaScope;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.basic.entity.Message;
import org.miaixz.bus.core.codec.binary.Base64;
import org.miaixz.bus.core.lang.Charset;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;

public class FigmaProvider
extends AbstractProvider {
    public FigmaProvider(Context context) {
        super(context, Registry.FIGMA);
    }

    public FigmaProvider(Context context, CacheX cache) {
        super(context, Registry.FIGMA, cache);
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(super.authorize(state)).queryParam("scope", this.getScopes(",", true, FigmaProvider.getDefaultScopes(FigmaScope.values()))).build();
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        HashMap<String, String> headers = new HashMap<String, String>(3);
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        headers.put("Authorization", "Basic ".concat(Base64.encode((byte[])this.context.getAppKey().concat(":").concat(this.context.getAppSecret()).getBytes(Charset.UTF_8))));
        String response = Httpx.post((String)super.accessTokenUrl(callback.getCode()), headers);
        try {
            Map accessTokenObject = (Map)JsonKit.toPojo((String)response, Map.class);
            if (accessTokenObject == null) {
                throw new AuthorizedException("Failed to parse access token response: empty response");
            }
            this.checkResponse(accessTokenObject);
            String accessToken = (String)accessTokenObject.get("access_token");
            if (accessToken == null) {
                throw new AuthorizedException("Missing access_token in response");
            }
            String refreshToken = (String)accessTokenObject.get("refresh_token");
            String scope = (String)accessTokenObject.get("scope");
            String userId = (String)accessTokenObject.get("user_id");
            Object expiresInObj = accessTokenObject.get("expires_in");
            int expiresIn = expiresInObj instanceof Number ? ((Number)expiresInObj).intValue() : 0;
            return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken(accessToken)).refreshToken(refreshToken)).scope(scope)).userId(userId)).expireIn(expiresIn)).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse access token response: " + e.getMessage());
        }
    }

    @Override
    public Message refresh(AuthToken authToken) {
        HashMap<String, String> headers = new HashMap<String, String>(3);
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        String response = Httpx.post((String)this.refreshTokenUrl(authToken.getRefreshToken()), headers);
        try {
            Map dataObj = (Map)JsonKit.toPojo((String)response, Map.class);
            if (dataObj == null) {
                throw new AuthorizedException("Failed to parse refresh token response: empty response");
            }
            this.checkResponse(dataObj);
            String accessToken = (String)dataObj.get("access_token");
            if (accessToken == null) {
                throw new AuthorizedException("Missing access_token in refresh response");
            }
            String openId = (String)dataObj.get("open_id");
            Object expiresInObj = dataObj.get("expires_in");
            int expiresIn = expiresInObj instanceof Number ? ((Number)expiresInObj).intValue() : 0;
            String refreshToken = (String)dataObj.get("refresh_token");
            String scope = (String)dataObj.get("scope");
            return Message.builder().errcode(ErrorCode._SUCCESS.getKey()).data(((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken(accessToken)).openId(openId)).expireIn(expiresIn)).refreshToken(refreshToken)).scope(scope)).build()).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse refresh token response: " + e.getMessage());
        }
    }

    @Override
    protected String refreshTokenUrl(String refreshToken) {
        return Builder.fromUrl(this.complex.refresh()).queryParam("client_id", this.context.getAppKey()).queryParam("client_secret", this.context.getAppSecret()).queryParam("refresh_token", refreshToken).build();
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        HashMap<String, Object> headers = new HashMap<String, Object>(3);
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        headers.put("Authorization", "Bearer " + authToken.getAccessToken());
        String response = Httpx.get((String)this.complex.userinfo(), null, headers);
        try {
            Map data = (Map)JsonKit.toPojo((String)response, Map.class);
            if (data == null) {
                throw new AuthorizedException("Failed to parse user info response: empty response");
            }
            this.checkResponse(data);
            String id = (String)data.get("id");
            if (id == null) {
                throw new AuthorizedException("Missing id in user info response");
            }
            String handle = (String)data.get("handle");
            String imgUrl = (String)data.get("img_url");
            String email = (String)data.get("email");
            return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().rawJson(JsonKit.toJsonString((Object)data))).uuid(id)).username(handle)).avatar(imgUrl)).email(email)).token(authToken)).source(this.complex.toString())).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse user info response: " + e.getMessage());
        }
    }

    private void checkResponse(Map<String, Object> object) {
        if (object.containsKey("error")) {
            String error = (String)object.get("error");
            String message = (String)object.get("message");
            throw new AuthorizedException((error != null ? error : "Unknown error") + ":" + (message != null ? message : "Unknown message"));
        }
    }
}

