/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.gitee;

import java.util.Map;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.auth.nimble.gitee.GiteeScope;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.lang.Gender;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.extra.json.JsonKit;

public class GiteeProvider
extends AbstractProvider {
    public GiteeProvider(Context context) {
        super(context, Registry.GITEE);
    }

    public GiteeProvider(Context context, CacheX cache) {
        super(context, Registry.GITEE, cache);
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        String response = this.doPostAuthorizationCode(callback.getCode());
        try {
            Map accessTokenObject = (Map)JsonKit.toPojo((String)response, Map.class);
            if (accessTokenObject == null) {
                throw new AuthorizedException("Failed to parse access token response: empty response");
            }
            this.checkResponse(accessTokenObject);
            String accessToken = (String)accessTokenObject.get("access_token");
            if (accessToken == null) {
                throw new AuthorizedException("Missing access_token in response");
            }
            String refreshToken = (String)accessTokenObject.get("refresh_token");
            String scope = (String)accessTokenObject.get("scope");
            String tokenType = (String)accessTokenObject.get("token_type");
            Object expiresInObj = accessTokenObject.get("expires_in");
            int expiresIn = expiresInObj instanceof Number ? ((Number)expiresInObj).intValue() : 0;
            return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken(accessToken)).refreshToken(refreshToken)).scope(scope)).tokenType(tokenType)).expireIn(expiresIn)).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse access token response: " + e.getMessage());
        }
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        String userInfo = this.doGetUserInfo(authToken);
        try {
            Map object = (Map)JsonKit.toPojo((String)userInfo, Map.class);
            if (object == null) {
                throw new AuthorizedException("Failed to parse user info response: empty response");
            }
            this.checkResponse(object);
            String id = (String)object.get("id");
            if (id == null) {
                throw new AuthorizedException("Missing id in user info response");
            }
            String login = (String)object.get("login");
            String avatarUrl = (String)object.get("avatar_url");
            String blog = (String)object.get("blog");
            String name = (String)object.get("name");
            String company = (String)object.get("company");
            String address = (String)object.get("address");
            String email = (String)object.get("email");
            String bio = (String)object.get("bio");
            return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().rawJson(JsonKit.toJsonString((Object)object))).uuid(id)).username(login)).avatar(avatarUrl)).blog(blog)).nickname(name)).company(company)).location(address)).email(email)).remark(bio)).gender(Gender.UNKNOWN)).token(authToken)).source(this.complex.toString())).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse user info response: " + e.getMessage());
        }
    }

    private void checkResponse(Map<String, Object> object) {
        if (object.containsKey("error")) {
            String errorDescription = (String)object.get("error_description");
            throw new AuthorizedException(errorDescription != null ? errorDescription : "Unknown error");
        }
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(super.authorize(state)).queryParam("scope", this.getScopes(" ", true, GiteeProvider.getDefaultScopes(GiteeScope.values()))).build();
    }
}

