/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.github;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Map;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.auth.nimble.github.GithubScope;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.lang.Gender;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;

public class GithubProvider
extends AbstractProvider {
    public GithubProvider(Context context) {
        super(context, Registry.GITHUB);
    }

    public GithubProvider(Context context, CacheX cache) {
        super(context, Registry.GITHUB, cache);
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        String response = this.doPostAuthorizationCode(callback.getCode());
        Map<String, String> res = Builder.parseStringToMap(response);
        this.checkResponse(res.containsKey("error"), res.get("error_description"));
        String accessToken = res.get("access_token");
        if (accessToken == null) {
            throw new AuthorizedException("Missing access_token in response");
        }
        return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken(accessToken)).scope(res.get("scope"))).tokenType(res.get("token_type"))).build();
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        HashMap<String, CallSite> header = new HashMap<String, CallSite>();
        header.put("Authorization", (CallSite)((Object)("token " + authToken.getAccessToken())));
        String response = Httpx.get((String)Builder.fromUrl(this.complex.userinfo()).build(), null, header);
        try {
            Map object = (Map)JsonKit.toPojo((String)response, Map.class);
            if (object == null) {
                throw new AuthorizedException("Failed to parse user info response: empty response");
            }
            this.checkResponse(object.containsKey("error"), (String)object.get("error_description"));
            String id = (String)object.get("id");
            if (id == null) {
                throw new AuthorizedException("Missing id in user info response");
            }
            String login = (String)object.get("login");
            String avatarUrl = (String)object.get("avatar_url");
            String blog = (String)object.get("blog");
            String name = (String)object.get("name");
            String company = (String)object.get("company");
            String location = (String)object.get("location");
            String email = (String)object.get("email");
            String bio = (String)object.get("bio");
            return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().rawJson(JsonKit.toJsonString((Object)object))).uuid(id)).username(login)).avatar(avatarUrl)).blog(blog)).nickname(name)).company(company)).location(location)).email(email)).remark(bio)).gender(Gender.UNKNOWN)).token(authToken)).source(this.complex.toString())).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse user info response: " + e.getMessage());
        }
    }

    private void checkResponse(boolean error, String errorDescription) {
        if (error) {
            throw new AuthorizedException(errorDescription != null ? errorDescription : "Unknown error");
        }
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(super.authorize(state)).queryParam("scope", this.getScopes(" ", true, GithubProvider.getDefaultScopes(GithubScope.values()))).build();
    }
}

