/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.gitlab;

import java.util.Map;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.auth.nimble.gitlab.GitlabScope;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.lang.Gender;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.extra.json.JsonKit;

public class GitlabProvider
extends AbstractProvider {
    public GitlabProvider(Context context) {
        super(context, Registry.GITLAB);
    }

    public GitlabProvider(Context context, CacheX cache) {
        super(context, Registry.GITLAB, cache);
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        String response = this.doPostAuthorizationCode(callback.getCode());
        try {
            Map object = (Map)JsonKit.toPojo((String)response, Map.class);
            if (object == null) {
                throw new AuthorizedException("Failed to parse access token response: empty response");
            }
            this.checkResponse(object);
            String accessToken = (String)object.get("access_token");
            if (accessToken == null) {
                throw new AuthorizedException("Missing access_token in response");
            }
            String refreshToken = (String)object.get("refresh_token");
            String idToken = (String)object.get("id_token");
            String tokenType = (String)object.get("token_type");
            String scope = (String)object.get("scope");
            return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken(accessToken)).refreshToken(refreshToken)).idToken(idToken)).tokenType(tokenType)).scope(scope)).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse access token response: " + e.getMessage());
        }
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        String response = this.doGetUserInfo(authToken);
        try {
            Map object = (Map)JsonKit.toPojo((String)response, Map.class);
            if (object == null) {
                throw new AuthorizedException("Failed to parse user info response: empty response");
            }
            this.checkResponse(object);
            String id = (String)object.get("id");
            if (id == null) {
                throw new AuthorizedException("Missing id in user info response");
            }
            String username = (String)object.get("username");
            String name = (String)object.get("name");
            String avatarUrl = (String)object.get("avatar_url");
            String webUrl = (String)object.get("web_url");
            String organization = (String)object.get("organization");
            String location = (String)object.get("location");
            String email = (String)object.get("email");
            String bio = (String)object.get("bio");
            return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().rawJson(JsonKit.toJsonString((Object)object))).uuid(id)).username(username)).nickname(name)).avatar(avatarUrl)).blog(webUrl)).company(organization)).location(location)).email(email)).remark(bio)).gender(Gender.UNKNOWN)).token(authToken)).source(this.complex.toString())).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse user info response: " + e.getMessage());
        }
    }

    private void checkResponse(Map<String, Object> object) {
        if (object.containsKey("error")) {
            String errorDescription = (String)object.get("error_description");
            throw new AuthorizedException(errorDescription != null ? errorDescription : "Unknown error");
        }
        if (object.containsKey("message")) {
            String message = (String)object.get("message");
            throw new AuthorizedException(message != null ? message : "Unknown error");
        }
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(super.authorize(state)).queryParam("scope", this.getScopes("+", false, GitlabProvider.getDefaultScopes(GitlabScope.values()))).build();
    }
}

