/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.google;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Map;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.auth.nimble.google.GoogleScope;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.lang.Gender;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;

public class GoogleProvider
extends AbstractProvider {
    public GoogleProvider(Context context) {
        super(context, Registry.GOOGLE);
    }

    public GoogleProvider(Context context, CacheX cache) {
        super(context, Registry.GOOGLE, cache);
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        String response = this.doPostAuthorizationCode(callback.getCode());
        try {
            Map accessTokenObject = (Map)JsonKit.toPojo((String)response, Map.class);
            if (accessTokenObject == null) {
                throw new AuthorizedException("Failed to parse access token response: empty response");
            }
            this.checkResponse(accessTokenObject);
            String accessToken = (String)accessTokenObject.get("access_token");
            if (accessToken == null) {
                throw new AuthorizedException("Missing access_token in response");
            }
            Object expiresInObj = accessTokenObject.get("expires_in");
            int expiresIn = expiresInObj instanceof Number ? ((Number)expiresInObj).intValue() : 0;
            String scope = (String)accessTokenObject.get("scope");
            String tokenType = (String)accessTokenObject.get("token_type");
            String idToken = (String)accessTokenObject.get("id_token");
            String refresh_token = (String)accessTokenObject.get("refresh_token");
            int refresh_token_expires_in = (Integer)accessTokenObject.get("refresh_token_expires_in");
            return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken(accessToken)).expireIn(expiresIn)).scope(scope)).tokenType(tokenType)).refreshToken(refresh_token)).refreshTokenExpireIn(refresh_token_expires_in)).idToken(idToken)).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse access token response: " + e.getMessage());
        }
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        HashMap<String, CallSite> header = new HashMap<String, CallSite>();
        header.put("Authorization", (CallSite)((Object)("Bearer " + authToken.getAccessToken())));
        String userInfo = Httpx.post((String)this.userInfoUrl(authToken), null, header);
        try {
            Map object = (Map)JsonKit.toPojo((String)userInfo, Map.class);
            if (object == null) {
                throw new AuthorizedException("Failed to parse user info response: empty response");
            }
            this.checkResponse(object);
            String sub = (String)object.get("sub");
            if (sub == null) {
                throw new AuthorizedException("Missing sub in user info response");
            }
            String email = (String)object.get("email");
            String picture = (String)object.get("picture");
            String name = (String)object.get("name");
            String locale = (String)object.get("locale");
            return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().rawJson(JsonKit.toJsonString((Object)object))).uuid(sub)).username(email)).avatar(picture)).nickname(name)).location(locale)).email(email)).gender(Gender.UNKNOWN)).token(authToken)).source(this.complex.toString())).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse user info response: " + e.getMessage());
        }
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(super.authorize(state)).queryParam("access_type", "offline").queryParam("scope", this.getScopes(" ", false, GoogleProvider.getDefaultScopes(GoogleScope.values()))).queryParam("prompt", "select_account").build();
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        return Builder.fromUrl(this.complex.userinfo()).queryParam("access_token", authToken.getAccessToken()).build();
    }

    private void checkResponse(Map<String, Object> object) {
        if (object.containsKey("error") || object.containsKey("error_description")) {
            String error = (String)object.get("error");
            String errorDescription = (String)object.get("error_description");
            throw new AuthorizedException((error != null ? error : "Unknown error") + ":" + (errorDescription != null ? errorDescription : "Unknown description"));
        }
    }
}

