/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.huawei;

import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.ErrorCode;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.auth.nimble.huawei.HuaweiScope;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.basic.entity.Message;
import org.miaixz.bus.core.lang.Charset;
import org.miaixz.bus.core.lang.Gender;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;

public class HuaweiProvider
extends AbstractProvider {
    public HuaweiProvider(Context context) {
        super(context, Registry.HUAWEI);
    }

    public HuaweiProvider(Context context, CacheX cache) {
        super(context, Registry.HUAWEI, cache);
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        HashMap<String, String> form = new HashMap<String, String>(8);
        form.put("grant_type", "authorization_code");
        form.put("code", callback.getCode());
        form.put("client_id", this.context.getAppKey());
        form.put("client_secret", this.context.getAppSecret());
        form.put("redirect_uri", this.context.getRedirectUri());
        if (this.context.isPkce()) {
            String cacheKey = this.complex.getName().concat(":code_verifier:").concat(callback.getState());
            String codeVerifier = (String)this.cache.read((Object)cacheKey);
            form.put("code_verifier", codeVerifier);
        }
        HashMap<String, String> header = new HashMap<String, String>(8);
        header.put("Content-Type", "application/x-www-form-urlencoded");
        String response = Httpx.post((String)this.complex.accessToken(), header, form);
        return this.getAuthToken(response);
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        String idToken = authToken.getIdToken();
        if (StringKit.isEmpty((CharSequence)idToken)) {
            HashMap<String, String> form = new HashMap<String, String>(7);
            form.put("access_token", authToken.getAccessToken());
            form.put("getNickName", "1");
            form.put("nsp_svc", "GOpen.User.getInfo");
            HashMap<String, String> header = new HashMap<String, String>(7);
            header.put("Content-Type", "application/x-www-form-urlencoded");
            String response = Httpx.post((String)this.complex.userinfo(), header, form);
            try {
                Map object = (Map)JsonKit.toPojo((String)response, Map.class);
                if (object == null) {
                    throw new AuthorizedException("Failed to parse user info response: empty response");
                }
                this.checkResponse(object);
                String unionID = (String)object.get("unionID");
                if (unionID == null) {
                    throw new AuthorizedException("Missing unionID in user info response");
                }
                String displayName = (String)object.get("displayName");
                String headPictureURL = (String)object.get("headPictureURL");
                return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().rawJson(JsonKit.toJsonString((Object)object))).uuid(unionID)).username(displayName)).nickname(displayName)).gender(Gender.UNKNOWN)).avatar(headPictureURL)).token(authToken)).source(this.context.toString())).build();
            }
            catch (Exception e) {
                throw new AuthorizedException("Failed to parse user info response: " + e.getMessage());
            }
        }
        String payload = new String(Base64.getUrlDecoder().decode(idToken.split("\\.")[1]), Charset.UTF_8);
        try {
            Map object = (Map)JsonKit.toPojo((String)payload, Map.class);
            if (object == null) {
                throw new AuthorizedException("Failed to parse id_token payload: empty response");
            }
            String sub = (String)object.get("sub");
            if (sub == null) {
                throw new AuthorizedException("Missing sub in id_token payload");
            }
            String name = (String)object.get("name");
            String nickname = (String)object.get("nickname");
            String picture = (String)object.get("picture");
            return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().rawJson(JsonKit.toJsonString((Object)object))).uuid(sub)).username(name)).nickname(nickname)).gender(Gender.UNKNOWN)).avatar(picture)).token(authToken)).source(this.complex.toString())).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse id_token payload: " + e.getMessage());
        }
    }

    @Override
    public Message refresh(AuthToken authToken) {
        HashMap<String, String> form = new HashMap<String, String>(7);
        form.put("client_id", this.context.getAppKey());
        form.put("client_secret", this.context.getAppSecret());
        form.put("refresh_token", authToken.getRefreshToken());
        form.put("grant_type", "refresh_token");
        HashMap<String, String> header = new HashMap<String, String>(7);
        header.put("Content-Type", "application/x-www-form-urlencoded");
        String response = Httpx.post((String)this.complex.refresh(), header, form);
        return Message.builder().errcode(ErrorCode._SUCCESS.getKey()).data((Object)this.getAuthToken(response)).build();
    }

    private AuthToken getAuthToken(String response) {
        try {
            Map object = (Map)JsonKit.toPojo((String)response, Map.class);
            if (object == null) {
                throw new AuthorizedException("Failed to parse access token response: empty response");
            }
            this.checkResponse(object);
            String accessToken = (String)object.get("access_token");
            if (accessToken == null) {
                throw new AuthorizedException("Missing access_token in response");
            }
            Object expiresInObj = object.get("expires_in");
            int expiresIn = expiresInObj instanceof Number ? ((Number)expiresInObj).intValue() : 0;
            String refreshToken = (String)object.get("refresh_token");
            String idToken = (String)object.get("id_token");
            return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken(accessToken)).expireIn(expiresIn)).refreshToken(refreshToken)).idToken(idToken)).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse access token response: " + e.getMessage());
        }
    }

    @Override
    public String authorize(String state) {
        String realState = this.getRealState(state);
        Builder builder = Builder.fromUrl(super.authorize(state)).queryParam("access_type", "offline").queryParam("scope", this.getScopes(" ", true, HuaweiProvider.getDefaultScopes(HuaweiScope.values())));
        if (this.context.isPkce()) {
            String cacheKey = this.complex.getName().concat(":code_verifier:").concat(realState);
            String codeVerifier = Builder.codeVerifier();
            String codeChallengeMethod = "S256";
            String codeChallenge = Builder.codeChallenge(codeChallengeMethod, codeVerifier);
            builder.queryParam("code_challenge", codeChallenge).queryParam("code_challenge_method", codeChallengeMethod);
            this.cache.write((Object)cacheKey, (Object)codeVerifier, TimeUnit.MINUTES.toMillis(10L));
        }
        return builder.build();
    }

    private void checkResponse(Map<String, Object> object) {
        if (object.containsKey("NSP_STATUS")) {
            String error = (String)object.get("error");
            throw new AuthorizedException(error != null ? error : "Unknown error");
        }
        if (object.containsKey("error")) {
            String subError = (String)object.get("sub_error");
            String errorDescription = (String)object.get("error_description");
            throw new AuthorizedException((subError != null ? subError : "Unknown sub_error") + ":" + (errorDescription != null ? errorDescription : "Unknown description"));
        }
    }
}

