/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.jd;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.ErrorCode;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.auth.nimble.jd.JdScope;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.basic.entity.Message;
import org.miaixz.bus.core.lang.Gender;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;

public class JdProvider
extends AbstractProvider {
    public JdProvider(Context context) {
        super(context, Registry.JD);
    }

    public JdProvider(Context context, CacheX cache) {
        super(context, Registry.JD, cache);
    }

    public static String sign(String appSecret, Map<String, Object> params) {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>(params);
        StringBuilder signBuilder = new StringBuilder(appSecret);
        for (Map.Entry entry : treeMap.entrySet()) {
            String name = (String)entry.getKey();
            String value = String.valueOf(entry.getValue());
            if (!StringKit.isNotEmpty((CharSequence)name) || !StringKit.isNotEmpty((CharSequence)value)) continue;
            signBuilder.append(name).append(value);
        }
        signBuilder.append(appSecret);
        return org.miaixz.bus.crypto.Builder.md5Hex((String)signBuilder.toString()).toUpperCase();
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        HashMap<String, String> form = new HashMap<String, String>(7);
        form.put("app_key", this.context.getAppKey());
        form.put("app_secret", this.context.getAppSecret());
        form.put("grant_type", "authorization_code");
        form.put("code", callback.getCode());
        String response = Httpx.post((String)this.complex.accessToken(), form);
        try {
            Map object = (Map)JsonKit.toPojo((String)response, Map.class);
            if (object == null) {
                throw new AuthorizedException("Failed to parse access token response: empty response");
            }
            this.checkResponse(object);
            String accessToken = (String)object.get("access_token");
            if (accessToken == null) {
                throw new AuthorizedException("Missing access_token in response");
            }
            Object expiresInObj = object.get("expires_in");
            int expiresIn = expiresInObj instanceof Number ? ((Number)expiresInObj).intValue() : 0;
            String refreshToken = (String)object.get("refresh_token");
            String scope = (String)object.get("scope");
            String openId = (String)object.get("open_id");
            return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken(accessToken)).expireIn(expiresIn)).refreshToken(refreshToken)).scope(scope)).openId(openId)).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse access token response: " + e.getMessage());
        }
    }

    private Map<String, Object> getUserDataJsonObject(Map<String, Object> object) {
        Map response = (Map)object.get("jingdong_user_getUserInfoByOpenId_response");
        if (response == null) {
            throw new AuthorizedException("Missing jingdong_user_getUserInfoByOpenId_response in response");
        }
        Map result = (Map)response.get("getuserinfobyappidandopenid_result");
        if (result == null) {
            throw new AuthorizedException("Missing getuserinfobyappidandopenid_result in response");
        }
        Map data = (Map)result.get("data");
        if (data == null) {
            throw new AuthorizedException("Missing data in response");
        }
        return data;
    }

    @Override
    public Message refresh(AuthToken authToken) {
        HashMap<String, String> form = new HashMap<String, String>(7);
        form.put("app_key", this.context.getAppKey());
        form.put("app_secret", this.context.getAppSecret());
        form.put("grant_type", "refresh_token");
        form.put("refresh_token", authToken.getRefreshToken());
        String response = Httpx.post((String)this.complex.refresh(), form);
        try {
            Map object = (Map)JsonKit.toPojo((String)response, Map.class);
            if (object == null) {
                throw new AuthorizedException("Failed to parse refresh token response: empty response");
            }
            this.checkResponse(object);
            String accessToken = (String)object.get("access_token");
            if (accessToken == null) {
                throw new AuthorizedException("Missing access_token in refresh response");
            }
            Object expiresInObj = object.get("expires_in");
            int expiresIn = expiresInObj instanceof Number ? ((Number)expiresInObj).intValue() : 0;
            String refreshToken = (String)object.get("refresh_token");
            String scope = (String)object.get("scope");
            String openId = (String)object.get("open_id");
            return Message.builder().errcode(ErrorCode._SUCCESS.getKey()).data(((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken(accessToken)).expireIn(expiresIn)).refreshToken(refreshToken)).scope(scope)).openId(openId)).build()).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse refresh token response: " + e.getMessage());
        }
    }

    private void checkResponse(Map<String, Object> object) {
        if (object.containsKey("error_response")) {
            Map errorResponse = (Map)object.get("error_response");
            String zhDesc = errorResponse != null ? (String)errorResponse.get("zh_desc") : null;
            throw new AuthorizedException(zhDesc != null ? zhDesc : "Unknown error");
        }
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        Builder urlBuilder = Builder.fromUrl(this.complex.userinfo()).queryParam("access_token", authToken.getAccessToken()).queryParam("app_key", this.context.getAppKey()).queryParam("method", "jingdong.user.getUserInfoByOpenId").queryParam("360buy_param_json", "{\"openId\":\"" + authToken.getOpenId() + "\"}").queryParam("timestamp", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))).queryParam("v", "2.0");
        urlBuilder.queryParam("sign", JdProvider.sign(this.context.getAppSecret(), urlBuilder.getReadOnlyParams()));
        String response = Httpx.post((String)urlBuilder.build(true));
        try {
            Map object = (Map)JsonKit.toPojo((String)response, Map.class);
            if (object == null) {
                throw new AuthorizedException("Failed to parse user info response: empty response");
            }
            this.checkResponse(object);
            Map<String, Object> data = this.getUserDataJsonObject(object);
            String nickName = (String)data.get("nickName");
            if (nickName == null) {
                throw new AuthorizedException("Missing nickName in user info response");
            }
            String imageUrl = (String)data.get("imageUrl");
            String gender = (String)data.get("gendar");
            return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().rawJson(JsonKit.toJsonString(data))).uuid(authToken.getOpenId())).username(nickName)).nickname(nickName)).avatar(imageUrl)).gender(Gender.of((String)gender))).token(authToken)).source(this.complex.toString())).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse user info response: " + e.getMessage());
        }
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(this.complex.authorize()).queryParam("app_key", this.context.getAppKey()).queryParam("response_type", "code").queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("scope", this.getScopes(" ", true, JdProvider.getDefaultScopes(JdScope.values()))).queryParam("state", this.getRealState(state)).build();
    }
}

