/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.kujiale;

import java.util.Map;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.ErrorCode;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.auth.nimble.kujiale.KujialeScope;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.basic.entity.Message;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;

public class KujialeProvider
extends AbstractProvider {
    public KujialeProvider(Context context) {
        super(context, Registry.KUJIALE);
    }

    public KujialeProvider(Context context, CacheX cache) {
        super(context, Registry.KUJIALE, cache);
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(super.authorize(state)).queryParam("scope", this.getScopes(",", false, KujialeProvider.getDefaultScopes(KujialeScope.values()))).build();
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        String response = this.doPostAuthorizationCode(callback.getCode());
        return this.getAuthToken(response);
    }

    private AuthToken getAuthToken(String response) {
        Map<String, Object> accessTokenObject = this.checkResponse(response);
        Map resultObject = (Map)accessTokenObject.get("d");
        if (resultObject == null) {
            throw new AuthorizedException("Missing d in access token response");
        }
        String accessToken = (String)resultObject.get("accessToken");
        if (accessToken == null) {
            throw new AuthorizedException("Missing accessToken in response");
        }
        String refreshToken = (String)resultObject.get("refreshToken");
        Object expiresInObj = resultObject.get("expiresIn");
        int expiresIn = expiresInObj instanceof Number ? ((Number)expiresInObj).intValue() : 0;
        return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken(accessToken)).refreshToken(refreshToken)).expireIn(expiresIn)).build();
    }

    private Map<String, Object> checkResponse(String response) {
        try {
            Map accessTokenObject = (Map)JsonKit.toPojo((String)response, Map.class);
            if (accessTokenObject == null) {
                throw new AuthorizedException("Failed to parse response: empty response");
            }
            String code = (String)accessTokenObject.get("c");
            if (!"0".equals(code)) {
                String message = (String)accessTokenObject.get("m");
                throw new AuthorizedException(message != null ? message : "Unknown error");
            }
            return accessTokenObject;
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse response: " + e.getMessage());
        }
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        String openId = this.getOpenId(authToken);
        String response = Httpx.get((String)Builder.fromUrl(this.complex.userinfo()).queryParam("access_token", authToken.getAccessToken()).queryParam("open_id", openId).build());
        try {
            Map object = (Map)JsonKit.toPojo((String)response, Map.class);
            if (object == null) {
                throw new AuthorizedException("Failed to parse user info response: empty response");
            }
            String code = (String)object.get("c");
            if (!"0".equals(code)) {
                String message = (String)object.get("m");
                throw new AuthorizedException(message != null ? message : "Unknown error");
            }
            Map resultObject = (Map)object.get("d");
            if (resultObject == null) {
                throw new AuthorizedException("Missing d in user info response");
            }
            String userName = (String)resultObject.get("userName");
            if (userName == null) {
                throw new AuthorizedException("Missing userName in user info response");
            }
            String avatar = (String)resultObject.get("avatar");
            String openIdFromResponse = (String)resultObject.get("openId");
            return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().rawJson(JsonKit.toJsonString((Object)resultObject))).username(userName)).nickname(userName)).avatar(avatar)).uuid(openIdFromResponse)).token(authToken)).source(this.complex.toString())).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse user info response: " + e.getMessage());
        }
    }

    private String getOpenId(AuthToken authToken) {
        String response = Httpx.get((String)Builder.fromUrl("https://oauth.kujiale.com/oauth2/auth/user").queryParam("access_token", authToken.getAccessToken()).build());
        Map<String, Object> accessTokenObject = this.checkResponse(response);
        String openId = (String)accessTokenObject.get("d");
        if (openId == null) {
            throw new AuthorizedException("Missing openId in response");
        }
        return openId;
    }

    @Override
    public Message refresh(AuthToken authToken) {
        String response = Httpx.post((String)this.refreshTokenUrl(authToken.getRefreshToken()));
        return Message.builder().errcode(ErrorCode._SUCCESS.getKey()).data((Object)this.getAuthToken(response)).build();
    }
}

