/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.line;

import java.util.HashMap;
import java.util.Map;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.ErrorCode;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.auth.nimble.line.LineScope;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.basic.entity.Message;
import org.miaixz.bus.core.basic.normal.Errors;
import org.miaixz.bus.core.lang.Gender;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;

public class LineProvider
extends AbstractProvider {
    public LineProvider(Context context) {
        super(context, Registry.LINE);
    }

    public LineProvider(Context context, CacheX cache) {
        super(context, Registry.LINE, cache);
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("grant_type", "authorization_code");
        params.put("code", callback.getCode());
        params.put("redirect_uri", this.context.getRedirectUri());
        params.put("client_id", this.context.getAppKey());
        params.put("client_secret", this.context.getAppSecret());
        String response = Httpx.post((String)this.complex.accessToken(), params);
        try {
            Map accessTokenObject = (Map)JsonKit.toPojo((String)response, Map.class);
            if (accessTokenObject == null) {
                throw new AuthorizedException("Failed to parse access token response: empty response");
            }
            String accessToken = (String)accessTokenObject.get("access_token");
            if (accessToken == null) {
                throw new AuthorizedException("Missing access_token in response");
            }
            String refreshToken = (String)accessTokenObject.get("refresh_token");
            Object expiresInObj = accessTokenObject.get("expires_in");
            int expiresIn = expiresInObj instanceof Number ? ((Number)expiresInObj).intValue() : 0;
            String idToken = (String)accessTokenObject.get("id_token");
            String scope = (String)accessTokenObject.get("scope");
            String tokenType = (String)accessTokenObject.get("token_type");
            return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken(accessToken)).refreshToken(refreshToken)).expireIn(expiresIn)).idToken(idToken)).scope(scope)).tokenType(tokenType)).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse access token response: " + e.getMessage());
        }
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        header.put("Authorization", "Bearer ".concat(authToken.getAccessToken()));
        String userInfo = Httpx.get((String)this.complex.userinfo(), null, header);
        try {
            Map object = (Map)JsonKit.toPojo((String)userInfo, Map.class);
            if (object == null) {
                throw new AuthorizedException("Failed to parse user info response: empty response");
            }
            String userId = (String)object.get("userId");
            if (userId == null) {
                throw new AuthorizedException("Missing userId in user info response");
            }
            String displayName = (String)object.get("displayName");
            String pictureUrl = (String)object.get("pictureUrl");
            String statusMessage = (String)object.get("statusMessage");
            return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().rawJson(JsonKit.toJsonString((Object)object))).uuid(userId)).username(displayName)).nickname(displayName)).avatar(pictureUrl)).remark(statusMessage)).gender(Gender.UNKNOWN)).token(authToken)).source(this.complex.toString())).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse user info response: " + e.getMessage());
        }
    }

    @Override
    public Message revoke(AuthToken authToken) {
        HashMap<String, String> form = new HashMap<String, String>(5);
        form.put("access_token", authToken.getAccessToken());
        form.put("client_id", this.context.getAppKey());
        form.put("client_secret", this.context.getAppSecret());
        String userInfo = Httpx.post((String)this.complex.revoke(), form);
        try {
            Map object = (Map)JsonKit.toPojo((String)userInfo, Map.class);
            if (object == null) {
                throw new AuthorizedException("Failed to parse revoke response: empty response");
            }
            Boolean revoked = (Boolean)object.get("revoked");
            Errors status = revoked != null && revoked != false ? ErrorCode._SUCCESS : ErrorCode._FAILURE;
            return Message.builder().errcode(status.getKey()).errmsg(status.getValue()).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse revoke response: " + e.getMessage());
        }
    }

    @Override
    public Message refresh(AuthToken authToken) {
        HashMap<String, String> form = new HashMap<String, String>();
        form.put("grant_type", "refresh_token");
        form.put("refresh_token", authToken.getRefreshToken());
        form.put("client_id", this.context.getAppKey());
        form.put("client_secret", this.context.getAppSecret());
        String response = Httpx.post((String)this.complex.accessToken(), form);
        try {
            Map accessTokenObject = (Map)JsonKit.toPojo((String)response, Map.class);
            if (accessTokenObject == null) {
                throw new AuthorizedException("Failed to parse refresh token response: empty response");
            }
            String accessToken = (String)accessTokenObject.get("access_token");
            if (accessToken == null) {
                throw new AuthorizedException("Missing access_token in refresh response");
            }
            String refreshToken = (String)accessTokenObject.get("refresh_token");
            Object expiresInObj = accessTokenObject.get("expires_in");
            int expiresIn = expiresInObj instanceof Number ? ((Number)expiresInObj).intValue() : 0;
            String idToken = (String)accessTokenObject.get("id_token");
            String scope = (String)accessTokenObject.get("scope");
            String tokenType = (String)accessTokenObject.get("token_type");
            return Message.builder().errcode(ErrorCode._SUCCESS.getKey()).data(((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken(accessToken)).refreshToken(refreshToken)).expireIn(expiresIn)).idToken(idToken)).scope(scope)).tokenType(tokenType)).build()).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse refresh token response: " + e.getMessage());
        }
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        return Builder.fromUrl(this.complex.userinfo()).queryParam("user", authToken.getUid()).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(super.authorize(state)).queryParam("nonce", state).queryParam("scope", this.getScopes(" ", true, LineProvider.getDefaultScopes(LineScope.values()))).build();
    }
}

