/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.linkedin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.ErrorCode;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.auth.nimble.linkedin.LinkedinScope;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.lang.Gender;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;

public class LinkedinProvider
extends AbstractProvider {
    public LinkedinProvider(Context context) {
        super(context, Registry.LINKEDIN);
    }

    public LinkedinProvider(Context context, CacheX cache) {
        super(context, Registry.LINKEDIN, cache);
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        return this.getToken(this.accessTokenUrl(callback.getCode()));
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        String accessToken = authToken.getAccessToken();
        HashMap<String, Object> header = new HashMap<String, Object>();
        header.put("Host", "api.linkedin.com");
        header.put("Connection", "Keep-Alive");
        header.put("Authorization", "Bearer " + accessToken);
        String response = Httpx.get((String)this.userInfoUrl(authToken), null, header);
        try {
            Map data = (Map)JsonKit.toPojo((String)response, Map.class);
            if (data == null) {
                throw new AuthorizedException("Failed to parse user info response: empty response");
            }
            this.checkResponse(data);
            String id = (String)data.get("id");
            if (id == null) {
                throw new AuthorizedException("Missing id in user info response");
            }
            String userName = this.getUserName(data);
            String avatar = this.getAvatar(data);
            String email = this.getUserEmail(accessToken);
            return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().rawJson(JsonKit.toJsonString((Object)data))).uuid(id)).username(userName)).nickname(userName)).avatar(avatar)).email(email)).token(authToken)).gender(Gender.UNKNOWN)).source(this.complex.toString())).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse user info response: " + e.getMessage());
        }
    }

    private String getUserName(Map<String, Object> data) {
        String firstName = data.containsKey("localizedFirstName") ? (String)data.get("localizedFirstName") : this.getUserName(data, "firstName");
        String lastName = data.containsKey("localizedLastName") ? (String)data.get("localizedLastName") : this.getUserName(data, "lastName");
        return firstName + " " + lastName;
    }

    private String getAvatar(Map<String, Object> data) {
        Map profilePictureObject = (Map)data.get("profilePicture");
        if (profilePictureObject == null || !profilePictureObject.containsKey("displayImage~")) {
            return null;
        }
        Map displayImageObject = (Map)profilePictureObject.get("displayImage~");
        if (displayImageObject == null || !displayImageObject.containsKey("elements")) {
            return null;
        }
        List displayImageElements = (List)displayImageObject.get("elements");
        if (displayImageElements == null || displayImageElements.isEmpty()) {
            return null;
        }
        Map largestImageObj = (Map)displayImageElements.get(displayImageElements.size() - 1);
        if (largestImageObj == null || !largestImageObj.containsKey("identifiers")) {
            return null;
        }
        List identifiers = (List)largestImageObj.get("identifiers");
        if (identifiers == null || identifiers.isEmpty()) {
            return null;
        }
        Map identifierObj = (Map)identifiers.get(0);
        return (String)identifierObj.get("identifier");
    }

    private String getUserEmail(String accessToken) {
        HashMap<String, Object> header = new HashMap<String, Object>();
        header.put("Host", "api.linkedin.com");
        header.put("Connection", "Keep-Alive");
        header.put("Authorization", "Bearer " + accessToken);
        String emailResponse = Httpx.get((String)"https://api.linkedin.com/v2/emailAddress?q=members&projection=(elements*(handle~))", null, header);
        try {
            Map emailObj = (Map)JsonKit.toPojo((String)emailResponse, Map.class);
            if (emailObj == null) {
                throw new AuthorizedException("Failed to parse email response: empty response");
            }
            this.checkResponse(emailObj);
            List elements = (List)emailObj.get("elements");
            if (elements == null || elements.isEmpty()) {
                return null;
            }
            Map handleObj = (Map)elements.get(0);
            Map handleInnerObj = (Map)handleObj.get("handle~");
            return handleInnerObj != null ? (String)handleInnerObj.get("emailAddress") : null;
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse email response: " + e.getMessage());
        }
    }

    private String getUserName(Map<String, Object> data, String nameKey) {
        Map nameObj = (Map)data.get(nameKey);
        if (nameObj == null) {
            return "";
        }
        Map localizedObj = (Map)nameObj.get("localized");
        Map preferredLocaleObj = (Map)nameObj.get("preferredLocale");
        if (localizedObj == null || preferredLocaleObj == null) {
            return "";
        }
        String language = (String)preferredLocaleObj.get("language");
        String country = (String)preferredLocaleObj.get("country");
        if (language == null || country == null) {
            return "";
        }
        return (String)localizedObj.get(language + "_" + country);
    }

    private void checkResponse(Map<String, Object> object) {
        if (object.containsKey("error")) {
            String errorDescription = (String)object.get("error_description");
            throw new AuthorizedException(ErrorCode._FAILURE.getKey(), new Object[]{errorDescription != null ? errorDescription : "Unknown error", this.complex.getName()});
        }
    }

    private AuthToken getToken(String accessTokenUrl) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Host", "www.linkedin.com");
        header.put("Content-Type", "application/x-www-form-urlencoded");
        String response = Httpx.post((String)accessTokenUrl, null, header);
        try {
            Map accessTokenObject = (Map)JsonKit.toPojo((String)response, Map.class);
            if (accessTokenObject == null) {
                throw new AuthorizedException("Failed to parse access token response: empty response");
            }
            this.checkResponse(accessTokenObject);
            String accessToken = (String)accessTokenObject.get("access_token");
            if (accessToken == null) {
                throw new AuthorizedException("Missing access_token in response");
            }
            Object expiresInObj = accessTokenObject.get("expires_in");
            int expiresIn = expiresInObj instanceof Number ? ((Number)expiresInObj).intValue() : 0;
            String refreshToken = (String)accessTokenObject.get("refresh_token");
            return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken(accessToken)).expireIn(expiresIn)).refreshToken(refreshToken)).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse access token response: " + e.getMessage());
        }
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(super.authorize(state)).queryParam("scope", this.getScopes(" ", false, LinkedinProvider.getDefaultScopes(LinkedinScope.values()))).build();
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        return Builder.fromUrl(this.complex.userinfo()).queryParam("projection", "(id,firstName,lastName,profilePicture(displayImage~:playableStreams))").build();
    }
}

