/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.mi;

import java.text.MessageFormat;
import java.util.Map;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.ErrorCode;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.auth.nimble.mi.MiScope;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.basic.entity.Message;
import org.miaixz.bus.core.lang.Gender;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;
import org.miaixz.bus.logger.Logger;

public class MiProvider
extends AbstractProvider {
    private static final String PREFIX = "&&&START&&&";

    public MiProvider(Context context) {
        super(context, Registry.MI);
    }

    public MiProvider(Context context, CacheX cache) {
        super(context, Registry.MI, cache);
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        return this.getToken(this.accessTokenUrl(callback.getCode()));
    }

    private AuthToken getToken(String accessTokenUrl) {
        String response = Httpx.get((String)accessTokenUrl);
        String jsonStr = response.replace(PREFIX, "");
        try {
            Map accessTokenObject = (Map)JsonKit.toPojo((String)jsonStr, Map.class);
            if (accessTokenObject == null) {
                throw new AuthorizedException("Failed to parse access token response: empty response");
            }
            if (accessTokenObject.containsKey("error")) {
                String errorDescription = (String)accessTokenObject.get("error_description");
                throw new AuthorizedException(errorDescription != null ? errorDescription : "Unknown error");
            }
            String accessToken = (String)accessTokenObject.get("access_token");
            if (accessToken == null) {
                throw new AuthorizedException("Missing access_token in response");
            }
            Object expiresInObj = accessTokenObject.get("expires_in");
            int expiresIn = expiresInObj instanceof Number ? ((Number)expiresInObj).intValue() : 0;
            String scope = (String)accessTokenObject.get("scope");
            String tokenType = (String)accessTokenObject.get("token_type");
            String refreshToken = (String)accessTokenObject.get("refresh_token");
            String openId = (String)accessTokenObject.get("openId");
            String macAlgorithm = (String)accessTokenObject.get("mac_algorithm");
            String macKey = (String)accessTokenObject.get("mac_key");
            return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken(accessToken)).expireIn(expiresIn)).scope(scope)).tokenType(tokenType)).refreshToken(refreshToken)).openId(openId)).macAlgorithm(macAlgorithm)).macKey(macKey)).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse access token response: " + e.getMessage());
        }
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        String userResponse = this.doGetUserInfo(authToken);
        try {
            Map userProfile = (Map)JsonKit.toPojo((String)userResponse, Map.class);
            if (userProfile == null) {
                throw new AuthorizedException("Failed to parse user info response: empty response");
            }
            String result = (String)userProfile.get("result");
            if ("error".equalsIgnoreCase(result)) {
                String description = (String)userProfile.get("description");
                throw new AuthorizedException(description != null ? description : "Unknown error");
            }
            Map object = (Map)userProfile.get("data");
            if (object == null) {
                throw new AuthorizedException("Missing data in user info response");
            }
            String miliaoNick = (String)object.get("miliaoNick");
            if (miliaoNick == null) {
                throw new AuthorizedException("Missing miliaoNick in user info response");
            }
            String miliaoIcon = (String)object.get("miliaoIcon");
            String mail = (String)object.get("mail");
            Object authUser = ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().rawJson(JsonKit.toJsonString((Object)object))).uuid(authToken.getOpenId())).username(miliaoNick)).nickname(miliaoNick)).avatar(miliaoIcon)).email(mail)).gender(Gender.UNKNOWN)).token(authToken)).source(this.complex.toString())).build();
            String emailPhoneUrl = MessageFormat.format("{0}?clientId={1}&token={2}", "https://open.account.xiaomi.com/user/phoneAndEmail", this.context.getAppKey(), authToken.getAccessToken());
            String emailResponse = Httpx.get((String)emailPhoneUrl);
            try {
                Map userEmailPhone = (Map)JsonKit.toPojo((String)emailResponse, Map.class);
                if (userEmailPhone == null) {
                    Logger.warn((String)"Failed to parse email/phone response: empty response", (Object[])new Object[0]);
                    return authUser;
                }
                String emailResult = (String)userEmailPhone.get("result");
                if (!"error".equalsIgnoreCase(emailResult)) {
                    Map emailPhone = (Map)userEmailPhone.get("data");
                    if (emailPhone != null) {
                        String email = (String)emailPhone.get("email");
                        ((Material)authUser).setEmail(email);
                    }
                } else {
                    Logger.warn((String)"Xiaomi developer platform currently does not provide access to user phone and email information", (Object[])new Object[0]);
                }
            }
            catch (Exception e) {
                Logger.warn((String)("Failed to parse email/phone response: " + e.getMessage()), (Object[])new Object[0]);
            }
            return authUser;
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse user info response: " + e.getMessage());
        }
    }

    @Override
    public Message refresh(AuthToken authToken) {
        return Message.builder().errcode(ErrorCode._SUCCESS.getKey()).data((Object)this.getToken(this.refreshTokenUrl(authToken.getRefreshToken()))).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(super.authorize(state)).queryParam("skip_confirm", "false").queryParam("scope", this.getScopes(" ", true, MiProvider.getDefaultScopes(MiScope.values()))).build();
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        return Builder.fromUrl(this.complex.userinfo()).queryParam("clientId", this.context.getAppKey()).queryParam("token", authToken.getAccessToken()).build();
    }
}

