/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.microsoft;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Map;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Complex;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.ErrorCode;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.auth.nimble.microsoft.MicrosoftScope;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.basic.entity.Message;
import org.miaixz.bus.core.lang.Gender;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.core.net.url.UrlDecoder;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;

public abstract class AbstractMicrosoftProvider
extends AbstractProvider {
    public AbstractMicrosoftProvider(Context context, Complex complex) {
        super(context, complex);
    }

    public AbstractMicrosoftProvider(Context context, Complex complex, CacheX cache) {
        super(context, complex, cache);
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        return this.getToken(this.accessTokenUrl(callback.getCode()));
    }

    private AuthToken getToken(String accessTokenUrl) {
        HashMap form = new HashMap();
        UrlDecoder.decodeMap((String)accessTokenUrl, (String)"UTF-8").forEach(form::put);
        String response = Httpx.post((String)accessTokenUrl, form);
        try {
            Map accessTokenObject = (Map)JsonKit.toPojo((String)response, Map.class);
            if (accessTokenObject == null) {
                throw new AuthorizedException("Failed to parse access token response: empty response");
            }
            this.checkResponse(accessTokenObject);
            String accessToken = (String)accessTokenObject.get("access_token");
            if (accessToken == null) {
                throw new AuthorizedException("Missing access_token in response");
            }
            Object expiresInObj = accessTokenObject.get("expires_in");
            int expiresIn = expiresInObj instanceof Number ? ((Number)expiresInObj).intValue() : 0;
            String scope = (String)accessTokenObject.get("scope");
            String tokenType = (String)accessTokenObject.get("token_type");
            String refreshToken = (String)accessTokenObject.get("refresh_token");
            return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken(accessToken)).expireIn(expiresIn)).scope(scope)).tokenType(tokenType)).refreshToken(refreshToken)).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse access token response: " + e.getMessage());
        }
    }

    private void checkResponse(Map<String, Object> object) {
        if (object.containsKey("error")) {
            String errorDescription = (String)object.get("error_description");
            throw new AuthorizedException(errorDescription != null ? errorDescription : "Unknown error");
        }
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        HashMap<String, CallSite> header = new HashMap<String, CallSite>();
        header.put("Authorization", (CallSite)((Object)(authToken.getTokenType() + " " + authToken.getAccessToken())));
        String userInfo = Httpx.get((String)this.userInfoUrl(authToken), null, header);
        try {
            Map object = (Map)JsonKit.toPojo((String)userInfo, Map.class);
            if (object == null) {
                throw new AuthorizedException("Failed to parse user info response: empty response");
            }
            this.checkResponse(object);
            String id = (String)object.get("id");
            if (id == null) {
                throw new AuthorizedException("Missing id in user info response");
            }
            String userPrincipalName = (String)object.get("userPrincipalName");
            String displayName = (String)object.get("displayName");
            String officeLocation = (String)object.get("officeLocation");
            String mail = (String)object.get("mail");
            return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().rawJson(JsonKit.toJsonString((Object)object))).uuid(id)).username(userPrincipalName)).nickname(displayName)).location(officeLocation)).email(mail)).gender(Gender.UNKNOWN)).token(authToken)).source(this.complex.toString())).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse user info response: " + e.getMessage());
        }
    }

    @Override
    public Message refresh(AuthToken authToken) {
        return Message.builder().errcode(ErrorCode._SUCCESS.getKey()).data((Object)this.getToken(this.refreshTokenUrl(authToken.getRefreshToken()))).build();
    }

    @Override
    public String authorize(String state) {
        String tenantId = StringKit.isEmpty((CharSequence)this.context.getUnionId()) ? "common" : this.context.getUnionId();
        return Builder.fromUrl(String.format(this.complex.authorize(), tenantId)).queryParam("response_type", "code").queryParam("client_id", this.context.getAppKey()).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("state", this.getRealState(state)).queryParam("response_mode", "query").queryParam("scope", this.getScopes(" ", false, AbstractMicrosoftProvider.getDefaultScopes(MicrosoftScope.values()))).build();
    }

    @Override
    protected String accessTokenUrl(String code) {
        String tenantId = StringKit.isEmpty((CharSequence)this.context.getUnionId()) ? "common" : this.context.getUnionId();
        return Builder.fromUrl(String.format(this.complex.accessToken(), tenantId)).queryParam("code", code).queryParam("client_id", this.context.getAppKey()).queryParam("client_secret", this.context.getAppSecret()).queryParam("grant_type", "authorization_code").queryParam("scope", this.getScopes(" ", false, AbstractMicrosoftProvider.getDefaultScopes(MicrosoftScope.values()))).queryParam("redirect_uri", this.context.getRedirectUri()).build();
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        return Builder.fromUrl(this.complex.userinfo()).build();
    }

    @Override
    protected String refreshTokenUrl(String refreshToken) {
        String tenantId = StringKit.isEmpty((CharSequence)this.context.getUnionId()) ? "common" : this.context.getUnionId();
        return Builder.fromUrl(String.format(this.complex.refresh(), tenantId)).queryParam("client_id", this.context.getAppKey()).queryParam("client_secret", this.context.getAppSecret()).queryParam("refresh_token", refreshToken).queryParam("grant_type", "refresh_token").queryParam("scope", this.getScopes(" ", false, AbstractMicrosoftProvider.getDefaultScopes(MicrosoftScope.values()))).queryParam("redirect_uri", this.context.getRedirectUri()).build();
    }
}

