/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.microsoft;

import lombok.Generated;
import org.miaixz.bus.auth.nimble.AuthorizeScope;

public enum MicrosoftScope implements AuthorizeScope
{
    PROFILE("profile", "Allows the app to view the user's basic personal profile (name, picture, username)", true),
    EMAIL("email", "Allows the app to read the user's primary email address", true),
    OPENID("openid", "Allows users to sign in to the app with their work or school account, and allows the app to view the user's basic profile information", true),
    OFFLINE_ACCESS("offline_access", "Allows the app to read and update user data, even when the user is not currently using this app", true),
    USER_READ("User.Read", "Sign in and read user profile", false),
    USER_READWRITE("User.ReadWrite", "Read and write permissions to user profile", false),
    USER_READBASIC_ALL("User.ReadBasic.All", "Read basic profiles of all users", false),
    USER_READ_ALL("User.Read.All", "Read full profiles of all users", false),
    USER_READWRITE_ALL("User.ReadWrite.All", "Read and write full profiles of all users", false),
    USER_INVITE_ALL("User.Invite.All", "Invite guest users to the organization", false),
    USER_EXPORT_ALL("User.Export.All", "Export user data", false),
    USER_MANAGEIDENTITIES_ALL("User.ManageIdentities.All", "Manage all user identities", false),
    USERACTIVITY_READWRITE_CREATEDBYAPP("UserActivity.ReadWrite.CreatedByApp", "Read and write app activities to the user's activity feed", false),
    FILES_READ("Files.Read", "Allows the app to read files of the signed-in user", false),
    FILES_READ_ALL("Files.Read.All", "Allows the app to read all files accessible to the signed-in user", false),
    FILES_READWRITE("Files.ReadWrite", "Allows the app to read, create, update, and delete files of the signed-in user", false),
    FILES_READWRITE_ALL("Files.ReadWrite.All", "Allows the app to read, create, update, and delete all files accessible to the signed-in user", false),
    FILES_READWRITE_APPFOLDER("Files.ReadWrite.AppFolder", "Allows the app to read, create, update, and delete files in the application folder", false),
    FILES_READ_SELECTED("Files.Read.Selected", "Allows the app to read files selected by the user. The app has access for several hours after the user selects files", false),
    FILES_READWRITE_SELECTED("Files.ReadWrite.Selected", "Allows the app to read and write files selected by the user. The app has access for several hours after the user selects files", false),
    ORGCONTACT_READ_ALL("OrgContact.Read.All", "Allows the app to read all organizational contacts on behalf of the signed-in user. These contacts are managed by the organization and are different from the user's personal contacts", false),
    MAIL_READ("Mail.Read", "Allows the app to read emails in the user's mailbox", false),
    MAIL_READBASIC("Mail.ReadBasic", "Allows the app to read the signed-in user's mailbox, but not the body, bodyPreview, uniqueBody, attachments, extensions, and any extended properties. Does not include mail search permissions", false),
    MAIL_READWRITE("Mail.ReadWrite", "Allows the app to create, read, update, and delete emails in the user's mailbox. Does not include permission to send emails", false),
    MAIL_READ_SHARED("Mail.Read.Shared", "Allows the app to read mail accessible to the user, including the user's personal mail and shared mail", false),
    MAIL_READWRITE_SHARED("Mail.ReadWrite.Shared", "Allows the app to create, read, update, and delete mail accessible to the user, including the user's personal mail and shared mail. Does not include mail sending permissions", false),
    MAIL_SEND("Mail.Send", "Allows the app to send mail as an organizational user", false),
    MAIL_SEND_SHARED("Mail.Send.Shared", "Allows the app to send mail as the signed-in user, including sending mail on behalf of others", false),
    MAILBOXSETTINGS_READ("MailboxSettings.Read", "Allows the app to read the user's mailbox settings. Does not include mail sending permissions", false),
    MAILBOXSETTINGS_READWRITE("MailboxSettings.ReadWrite", "Allows the app to create, read, update, and delete user mailbox settings. Does not include direct mail sending permissions, but allows the app to create rules that can forward or redirect mail", false),
    NOTES_READ("Notes.Read", "Allows the app to read OneNote notebooks and section titles on behalf of the signed-in user and create new pages, notebooks, and sections", false),
    NOTES_CREATE("Notes.Create", "Allows the app to create user OneNote notebooks", false),
    NOTES_READWRITE("Notes.ReadWrite", "Allows the app to read, share, and modify OneNote notebooks on behalf of the signed-in user", false),
    NOTES_READ_ALL("Notes.Read.All", "Allows the app to read OneNote notebooks accessible to the signed-in user in the organization", false),
    NOTES_READWRITE_ALL("Notes.ReadWrite.All", "Allows the app to read, share, and modify OneNote notebooks accessible to the signed-in user in the organization", false);

    private final String scope;
    private final String description;
    private final boolean isDefault;

    @Override
    @Generated
    public String getScope() {
        return this.scope;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Override
    @Generated
    public boolean isDefault() {
        return this.isDefault;
    }

    @Generated
    private MicrosoftScope(String scope, String description, boolean isDefault) {
        this.scope = scope;
        this.description = description;
        this.isDefault = isDefault;
    }
}

