/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.okta;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Map;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.ErrorCode;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.auth.nimble.okta.OktaScope;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.basic.entity.Message;
import org.miaixz.bus.core.codec.binary.Base64;
import org.miaixz.bus.core.lang.Gender;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;

public class OktaProvider
extends AbstractProvider {
    public OktaProvider(Context context) {
        super(context, Registry.OKTA);
    }

    public OktaProvider(Context context, CacheX cache) {
        super(context, Registry.OKTA, cache);
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        String tokenUrl = this.accessTokenUrl(callback.getCode());
        return this.getAuthToken(tokenUrl);
    }

    private AuthToken getAuthToken(String tokenUrl) {
        HashMap<String, Object> header = new HashMap<String, Object>();
        header.put("accept", "application/json");
        header.put("Content-Type", "application/x-www-form-urlencoded");
        header.put("Authorization", "Basic " + Base64.encode((CharSequence)this.context.getAppKey().concat(":").concat(this.context.getAppSecret())));
        String response = Httpx.post((String)tokenUrl, null, header);
        try {
            Map accessTokenObject = (Map)JsonKit.toPojo((String)response, Map.class);
            if (accessTokenObject == null) {
                throw new AuthorizedException("Failed to parse access token response: empty response");
            }
            this.checkResponse(accessTokenObject);
            String accessToken = (String)accessTokenObject.get("access_token");
            if (accessToken == null) {
                throw new AuthorizedException("Missing access_token in response");
            }
            String tokenType = (String)accessTokenObject.get("token_type");
            Object expiresInObj = accessTokenObject.get("expires_in");
            int expiresIn = expiresInObj instanceof Number ? ((Number)expiresInObj).intValue() : 0;
            String scope = (String)accessTokenObject.get("scope");
            String refreshToken = (String)accessTokenObject.get("refresh_token");
            String idToken = (String)accessTokenObject.get("id_token");
            return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken(accessToken)).tokenType(tokenType)).expireIn(expiresIn)).scope(scope)).refreshToken(refreshToken)).idToken(idToken)).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse access token response: " + e.getMessage());
        }
    }

    @Override
    public Message refresh(AuthToken authToken) {
        if (null == authToken.getRefreshToken()) {
            return Message.builder().errcode(ErrorCode.ILLEGAL_TOKEN.getKey()).errmsg(ErrorCode.ILLEGAL_TOKEN.getValue()).build();
        }
        String refreshUrl = this.refreshTokenUrl(authToken.getRefreshToken());
        return Message.builder().errcode(ErrorCode._SUCCESS.getKey()).data((Object)this.getAuthToken(refreshUrl)).build();
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        HashMap<String, CallSite> header = new HashMap<String, CallSite>();
        header.put("Authorization", (CallSite)((Object)("Bearer " + authToken.getAccessToken())));
        String response = Httpx.post((String)this.userInfoUrl(authToken), null, header);
        try {
            Map object = (Map)JsonKit.toPojo((String)response, Map.class);
            if (object == null) {
                throw new AuthorizedException("Failed to parse user info response: empty response");
            }
            this.checkResponse(object);
            String sub = (String)object.get("sub");
            if (sub == null) {
                throw new AuthorizedException("Missing sub in user info response");
            }
            String name = (String)object.get("name");
            String nickname = (String)object.get("nickname");
            String email = (String)object.get("email");
            String sex = (String)object.get("sex");
            Map address = (Map)object.get("address");
            String streetAddress = address != null ? (String)address.get("street_address") : null;
            return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().rawJson(JsonKit.toJsonString((Object)object))).uuid(sub)).username(name)).nickname(nickname)).email(email)).location(streetAddress)).gender(Gender.of((String)sex))).token(authToken)).source(this.complex.toString())).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse user info response: " + e.getMessage());
        }
    }

    @Override
    public Message revoke(AuthToken authToken) {
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("token", authToken.getAccessToken());
        params.put("token_type_hint", "access_token");
        HashMap<String, CallSite> header = new HashMap<String, CallSite>();
        header.put("Authorization", (CallSite)((Object)("Basic " + Base64.encode((CharSequence)this.context.getAppKey().concat(":").concat(this.context.getAppSecret())))));
        Httpx.post((String)this.revokeUrl(authToken), params, header);
        return Message.builder().errcode(ErrorCode._SUCCESS.getKey()).errmsg(ErrorCode._SUCCESS.getValue()).build();
    }

    private void checkResponse(Map<String, Object> object) {
        if (object.containsKey("error")) {
            String errorDescription = (String)object.get("error_description");
            throw new AuthorizedException(errorDescription != null ? errorDescription : "Unknown error");
        }
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(String.format(this.complex.authorize(), this.context.getPrefix(), ObjectKit.defaultIfNull((Object)this.context.getUnionId(), (Object)"default"))).queryParam("response_type", "code").queryParam("prompt", "consent").queryParam("client_id", this.context.getAppKey()).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("scope", this.getScopes(" ", true, OktaProvider.getDefaultScopes(OktaScope.values()))).queryParam("state", this.getRealState(state)).build();
    }

    @Override
    public String accessTokenUrl(String code) {
        return Builder.fromUrl(String.format(this.complex.accessToken(), this.context.getPrefix(), ObjectKit.defaultIfNull((Object)this.context.getUnionId(), (Object)"default"))).queryParam("code", code).queryParam("grant_type", "authorization_code").queryParam("redirect_uri", this.context.getRedirectUri()).build();
    }

    @Override
    protected String refreshTokenUrl(String refreshToken) {
        return Builder.fromUrl(String.format(this.complex.refresh(), this.context.getPrefix(), ObjectKit.defaultIfNull((Object)this.context.getUnionId(), (Object)"default"))).queryParam("refresh_token", refreshToken).queryParam("grant_type", "refresh_token").build();
    }

    @Override
    protected String revokeUrl(AuthToken authToken) {
        return String.format(this.complex.revoke(), this.context.getPrefix(), ObjectKit.defaultIfNull((Object)this.context.getUnionId(), (Object)"default"));
    }

    @Override
    public String userInfoUrl(AuthToken authToken) {
        return String.format(this.complex.userinfo(), this.context.getPrefix(), ObjectKit.defaultIfNull((Object)this.context.getUnionId(), (Object)"default"));
    }
}

