/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.pinterest;

import java.util.Map;
import java.util.Objects;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.auth.nimble.pinterest.PinterestScope;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.lang.Gender;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;

public class PinterestProvider
extends AbstractProvider {
    private static final String FAILURE = "failure";

    public PinterestProvider(Context context) {
        super(context, Registry.PINTEREST);
    }

    public PinterestProvider(Context context, CacheX cache) {
        super(context, Registry.PINTEREST, cache);
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        String response = this.doPostAuthorizationCode(callback.getCode());
        try {
            Map accessTokenObject = (Map)JsonKit.toPojo((String)response, Map.class);
            if (accessTokenObject == null) {
                throw new AuthorizedException("Failed to parse access token response: empty response");
            }
            this.checkResponse(accessTokenObject);
            String accessToken = (String)accessTokenObject.get("access_token");
            if (accessToken == null) {
                throw new AuthorizedException("Missing access_token in response");
            }
            String tokenType = (String)accessTokenObject.get("token_type");
            return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken(accessToken)).tokenType(tokenType)).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse access token response: " + e.getMessage());
        }
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        String userinfoUrl = this.userInfoUrl(authToken);
        String response = Httpx.get((String)userinfoUrl);
        try {
            Map object = (Map)JsonKit.toPojo((String)response, Map.class);
            if (object == null) {
                throw new AuthorizedException("Failed to parse user info response: empty response");
            }
            this.checkResponse(object);
            Map userObj = (Map)object.get("data");
            if (userObj == null) {
                throw new AuthorizedException("Missing data in user info response");
            }
            String id = (String)userObj.get("id");
            if (id == null) {
                throw new AuthorizedException("Missing id in user info response");
            }
            String username = (String)userObj.get("username");
            String firstName = (String)userObj.get("first_name");
            String lastName = (String)userObj.get("last_name");
            String bio = (String)userObj.get("bio");
            String avatar = this.getAvatarUrl(userObj);
            return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().rawJson(JsonKit.toJsonString((Object)userObj))).uuid(id)).avatar(avatar)).username(username)).nickname(firstName + " " + lastName)).gender(Gender.UNKNOWN)).remark(bio)).token(authToken)).source(this.complex.toString())).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse user info response: " + e.getMessage());
        }
    }

    private String getAvatarUrl(Map<String, Object> userObj) {
        Map jsonObject = (Map)userObj.get("image");
        if (Objects.isNull(jsonObject)) {
            return null;
        }
        Map avatarObj = (Map)jsonObject.get("60x60");
        return avatarObj != null ? (String)avatarObj.get("url") : null;
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(super.authorize(state)).queryParam("scope", this.getScopes(",", false, PinterestProvider.getDefaultScopes(PinterestScope.values()))).build();
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        return Builder.fromUrl(this.complex.userinfo()).queryParam("access_token", authToken.getAccessToken()).queryParam("fields", "id,username,first_name,last_name,bio,image").build();
    }

    private void checkResponse(Map<String, Object> object) {
        String status = (String)object.get("status");
        if (!object.containsKey("status") || FAILURE.equals(status)) {
            String message = (String)object.get("message");
            throw new AuthorizedException(message != null ? message : "Unknown error");
        }
    }
}

