/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.proginn;

import java.util.HashMap;
import java.util.Map;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.auth.nimble.proginn.ProginnScope;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.lang.Gender;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;

public class ProginnProvider
extends AbstractProvider {
    public ProginnProvider(Context context) {
        super(context, Registry.PROGINN);
    }

    public ProginnProvider(Context context, CacheX cache) {
        super(context, Registry.PROGINN, cache);
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("code", callback.getCode());
        params.put("client_id", this.context.getAppKey());
        params.put("client_secret", this.context.getAppSecret());
        params.put("grant_type", "authorization_code");
        params.put("redirect_uri", this.context.getRedirectUri());
        String response = Httpx.post((String)this.complex.accessToken(), params);
        Map accessTokenObject = (Map)JsonKit.toPojo((String)response, Map.class);
        this.checkResponse(accessTokenObject);
        return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken((String)accessTokenObject.get("access_token"))).refreshToken((String)accessTokenObject.get("refresh_token"))).uid((String)accessTokenObject.get("uid"))).tokenType((String)accessTokenObject.get("token_type"))).expireIn(((Number)accessTokenObject.get("expires_in")).intValue())).build();
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        String userInfo = this.doGetUserInfo(authToken);
        Map object = (Map)JsonKit.toPojo((String)userInfo, Map.class);
        this.checkResponse(object);
        return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().rawJson(JsonKit.toJsonString((Object)object))).uuid((String)object.get("uid"))).username((String)object.get("nickname"))).nickname((String)object.get("nickname"))).avatar((String)object.get("avatar"))).email((String)object.get("email"))).gender(Gender.UNKNOWN)).token(authToken)).source(this.complex.toString())).build();
    }

    private void checkResponse(Map<String, Object> object) {
        if (object.containsKey("error")) {
            throw new AuthorizedException((String)object.get("error_description"));
        }
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(super.authorize(state)).queryParam("scope", this.getScopes(" ", true, ProginnProvider.getDefaultScopes(ProginnScope.values()))).build();
    }
}

