/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.qq;

import java.util.Map;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.ErrorCode;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.auth.nimble.qq.QqScope;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.basic.entity.Message;
import org.miaixz.bus.core.lang.Gender;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;

public class QqProvider
extends AbstractProvider {
    public QqProvider(Context context) {
        super(context, Registry.QQ);
    }

    public QqProvider(Context context, CacheX cache) {
        super(context, Registry.QQ, cache);
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        String response = this.doGetAuthorizationCode(callback.getCode());
        return this.getAuthToken(response);
    }

    @Override
    public Message refresh(AuthToken authToken) {
        String response = Httpx.get((String)this.refreshTokenUrl(authToken.getRefreshToken()));
        return Message.builder().errcode(ErrorCode._SUCCESS.getKey()).data((Object)this.getAuthToken(response)).build();
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        String openId = this.getOpenId(authToken);
        String response = this.doGetUserInfo(authToken);
        Map object = (Map)JsonKit.toPojo((String)response, Map.class);
        if (!"0".equals(object.get("ret"))) {
            throw new AuthorizedException((String)object.get("msg"));
        }
        String avatar = (String)object.get("figureurl_qq_2");
        if (StringKit.isEmpty((CharSequence)avatar)) {
            avatar = (String)object.get("figureurl_qq_1");
        }
        String location = String.format("%s-%s", object.get("province"), object.get("city"));
        return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().rawJson(JsonKit.toJsonString((Object)object))).username((String)object.get("nickname"))).nickname((String)object.get("nickname"))).avatar(avatar)).location(location)).uuid(openId)).gender(Gender.of((String)((String)object.get("gender"))))).token(authToken)).source(this.complex.toString())).build();
    }

    private String getOpenId(AuthToken authToken) {
        String response = Httpx.get((String)Builder.fromUrl("https://graph.qq.com/oauth2.0/me").queryParam("access_token", authToken.getAccessToken()).queryParam("unionid", this.context.isFlag() ? 1 : 0).build());
        String removePrefix = response.replace("callback(", "");
        String removeSuffix = removePrefix.replace(");", "");
        String openId = removeSuffix.trim();
        Map object = (Map)JsonKit.toPojo((String)openId, Map.class);
        if (object.containsKey("error")) {
            throw new AuthorizedException((String)object.get("error") + ":" + (String)object.get("error_description"));
        }
        authToken.setOpenId((String)object.get("openid"));
        if (object.containsKey("unionid")) {
            authToken.setUnionId((String)object.get("unionid"));
        }
        return StringKit.isEmpty((CharSequence)authToken.getUnionId()) ? authToken.getOpenId() : authToken.getUnionId();
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        return Builder.fromUrl(this.complex.userinfo()).queryParam("access_token", authToken.getAccessToken()).queryParam("oauth_consumer_key", this.context.getAppKey()).queryParam("openid", authToken.getOpenId()).build();
    }

    private AuthToken getAuthToken(String response) {
        Map<String, String> accessTokenObject = Builder.parseStringToMap(response);
        if (!accessTokenObject.containsKey("access_token") || accessTokenObject.containsKey("code")) {
            throw new AuthorizedException(accessTokenObject.get("msg"));
        }
        return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken(accessTokenObject.get("access_token"))).expireIn(Integer.parseInt(accessTokenObject.getOrDefault("expires_in", "0")))).refreshToken(accessTokenObject.get("refresh_token"))).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(super.authorize(state)).queryParam("scope", this.getScopes(",", false, QqProvider.getDefaultScopes(QqScope.values()))).build();
    }
}

