/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.rednote;

import java.util.HashMap;
import java.util.Map;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.ErrorCode;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.auth.nimble.rednote.RednoteMarketiScope;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.basic.entity.Message;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;

public class RednoteMarketiProvider
extends AbstractProvider {
    public RednoteMarketiProvider(Context context) {
        super(context, Registry.REDNOTE_MARKET);
    }

    public RednoteMarketiProvider(Context context, CacheX cache) {
        super(context, Registry.REDNOTE_MARKET, cache);
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(this.complex.authorize()).queryParam("appId", this.context.getAppKey()).queryParam("scope", this.getScopes(" ", true, RednoteMarketiProvider.getDefaultScopes(RednoteMarketiScope.values()))).queryParam("redirectUri", this.context.getRedirectUri()).queryParam("state", this.getRealState(state)).build();
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        HashMap<String, String> form = new HashMap<String, String>(7);
        form.put("app_id", this.context.getAppKey());
        form.put("secret", this.context.getAppSecret());
        form.put("code", callback.getCode());
        String response = Httpx.post((String)this.complex.accessToken(), form);
        try {
            Map object = (Map)JsonKit.toPojo((String)response, Map.class);
            if (object == null) {
                throw new AuthorizedException("Failed to parse access token response: empty response");
            }
            this.checkResponse(object);
            String accessToken = (String)object.get("access_token");
            if (accessToken == null) {
                throw new AuthorizedException("Missing access_token in response");
            }
            return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken((String)object.get("access_token"))).expireIn((Integer)object.get("access_token_expires_in"))).refreshToken((String)object.get("refresh_token"))).scope((String)object.get("scope"))).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse access token response: " + e.getMessage());
        }
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        throw new UnsupportedOperationException("User info URL is not supported");
    }

    @Override
    public Message refresh(AuthToken authToken) {
        HashMap<String, String> form = new HashMap<String, String>(7);
        form.put("app_id", this.context.getAppKey());
        form.put("secret", this.context.getAppSecret());
        form.put("refresh_token", authToken.getRefreshToken());
        String response = Httpx.post((String)this.complex.refresh(), form);
        try {
            Map object = (Map)JsonKit.toPojo((String)response, Map.class);
            if (object == null) {
                throw new AuthorizedException("Failed to parse access token response: empty response");
            }
            this.checkResponse(object);
            String accessToken = (String)object.get("access_token");
            if (accessToken == null) {
                throw new AuthorizedException("Missing access_token in response");
            }
            return Message.builder().errcode(ErrorCode._SUCCESS.getKey()).data(((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken((String)object.get("access_token"))).refreshToken((String)object.get("refresh_token"))).scope((String)object.get("scope"))).expireIn((Integer)object.get("expires_in"))).build()).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse access token response: " + e.getMessage());
        }
    }

    private void checkResponse(Map<String, Object> object) {
        if ((Integer)object.get("code") != 0) {
            String error = (String)object.get("error");
            throw new AuthorizedException(error != null ? error : "Unknown error");
        }
        if (object.containsKey("error")) {
            String subError = (String)object.get("sub_error");
            String errorDescription = (String)object.get("error_description");
            throw new AuthorizedException((subError != null ? subError : "Unknown sub_error") + ":" + (errorDescription != null ? errorDescription : "Unknown description"));
        }
    }
}

