/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.renren;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.ErrorCode;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.auth.nimble.renren.RenrenScope;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.basic.entity.Message;
import org.miaixz.bus.core.lang.Gender;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.core.net.url.UrlEncoder;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;

public class RenrenProvider
extends AbstractProvider {
    public RenrenProvider(Context context) {
        super(context, Registry.RENREN);
    }

    public RenrenProvider(Context context, CacheX cache) {
        super(context, Registry.RENREN, cache);
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        return this.getToken(this.accessTokenUrl(callback.getCode()));
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        String response = this.doGetUserInfo(authToken);
        Map userObj = (Map)((Map)JsonKit.toPojo((String)response, Map.class)).get("response");
        return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().rawJson(JsonKit.toJsonString((Object)userObj))).uuid((String)userObj.get("id"))).avatar(this.getAvatarUrl(userObj))).nickname((String)userObj.get("name"))).company(this.getCompany(userObj))).gender(this.getGender(userObj))).token(authToken)).source(this.complex.toString())).build();
    }

    @Override
    public Message refresh(AuthToken authToken) {
        return Message.builder().errcode(ErrorCode._SUCCESS.getKey()).data((Object)this.getToken(this.refreshTokenUrl(authToken.getRefreshToken()))).build();
    }

    private AuthToken getToken(String url) {
        String response = Httpx.post((String)url);
        Map jsonObject = (Map)JsonKit.toPojo((String)response, Map.class);
        if (jsonObject.containsKey("error")) {
            throw new AuthorizedException("Failed to get token from Renren: " + String.valueOf(jsonObject));
        }
        return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().tokenType((String)jsonObject.get("token_type"))).expireIn(((Number)jsonObject.get("expires_in")).intValue())).accessToken(UrlEncoder.encodeAll((String)((String)jsonObject.get("access_token"))))).refreshToken(UrlEncoder.encodeAll((String)((String)jsonObject.get("refresh_token"))))).openId(((Map)jsonObject.get("user")).get("id").toString())).build();
    }

    private String getAvatarUrl(Map<String, Object> userObj) {
        List jsonArray = (List)userObj.get("avatar");
        if (Objects.isNull(jsonArray) || jsonArray.isEmpty()) {
            return null;
        }
        return ((Map)jsonArray.get(0)).get("url").toString();
    }

    private Gender getGender(Map<String, Object> userObj) {
        Map basicInformation = (Map)userObj.get("basicInformation");
        if (Objects.isNull(basicInformation)) {
            return Gender.UNKNOWN;
        }
        return Gender.of((String)((String)basicInformation.get("sex")));
    }

    private String getCompany(Map<String, Object> userObj) {
        List jsonArray = (List)userObj.get("work");
        if (Objects.isNull(jsonArray) || jsonArray.isEmpty()) {
            return null;
        }
        return ((Map)jsonArray.get(0)).get("name").toString();
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        return Builder.fromUrl(this.complex.userinfo()).queryParam("access_token", authToken.getAccessToken()).queryParam("userId", authToken.getOpenId()).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(super.authorize(state)).queryParam("scope", this.getScopes(",", false, RenrenProvider.getDefaultScopes(RenrenScope.values()))).build();
    }
}

