/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.slack;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.ErrorCode;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.auth.nimble.slack.SlackScope;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.basic.entity.Message;
import org.miaixz.bus.core.basic.normal.Errors;
import org.miaixz.bus.core.lang.Gender;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;

public class SlackProvider
extends AbstractProvider {
    public SlackProvider(Context context) {
        super(context, Registry.SLACK);
    }

    public SlackProvider(Context context, CacheX cache) {
        super(context, Registry.SLACK, cache);
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        String response = Httpx.get((String)this.accessTokenUrl(callback.getCode()), null, header);
        Map accessTokenObject = (Map)JsonKit.toPojo((String)response, Map.class);
        this.checkResponse(accessTokenObject);
        return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken((String)accessTokenObject.get("access_token"))).scope((String)accessTokenObject.get("scope"))).tokenType((String)accessTokenObject.get("token_type"))).uid(((Map)accessTokenObject.get("authed_user")).get("id").toString())).build();
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        header.put("Authorization", "Bearer ".concat(authToken.getAccessToken()));
        String userInfo = Httpx.get((String)this.userInfoUrl(authToken), null, header);
        Map object = (Map)JsonKit.toPojo((String)userInfo, Map.class);
        this.checkResponse(object);
        Map user = (Map)object.get("user");
        Map profile = (Map)user.get("profile");
        return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().rawJson(JsonKit.toJsonString((Object)user))).uuid((String)user.get("id"))).username((String)user.get("name"))).nickname((String)user.get("real_name"))).avatar((String)profile.get("image_original"))).email((String)profile.get("email"))).gender(Gender.UNKNOWN)).token(authToken)).source(this.complex.toString())).build();
    }

    @Override
    public Message revoke(AuthToken authToken) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        header.put("Authorization", "Bearer ".concat(authToken.getAccessToken()));
        String userInfo = Httpx.get((String)this.complex.revoke(), null, header);
        Map object = (Map)JsonKit.toPojo((String)userInfo, Map.class);
        this.checkResponse(object);
        Errors status = (Boolean)object.get("revoked") != false ? ErrorCode._SUCCESS : ErrorCode._FAILURE;
        return Message.builder().errcode(status.getKey()).errmsg(status.getValue()).build();
    }

    private void checkResponse(Map<String, Object> object) {
        if (!((Boolean)object.get("ok")).booleanValue()) {
            List messages;
            Map responseMetadata;
            Object errorMsg = (String)object.get("error");
            if (object.containsKey("response_metadata") && (responseMetadata = (Map)object.get("response_metadata")).containsKey("messages") && (messages = (List)responseMetadata.get("messages")) != null && !messages.isEmpty()) {
                errorMsg = (String)errorMsg + "; " + StringKit.join((CharSequence)",", (Object[])messages.toArray(new String[0]));
            }
            throw new AuthorizedException((String)errorMsg);
        }
    }

    @Override
    public String userInfoUrl(AuthToken authToken) {
        return Builder.fromUrl(this.complex.userinfo()).queryParam("user", authToken.getUid()).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(this.complex.authorize()).queryParam("client_id", this.context.getAppKey()).queryParam("state", this.getRealState(state)).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("scope", this.getScopes(",", true, SlackProvider.getDefaultScopes(SlackScope.values()))).build();
    }

    @Override
    protected String accessTokenUrl(String code) {
        return Builder.fromUrl(this.complex.accessToken()).queryParam("code", code).queryParam("client_id", this.context.getAppKey()).queryParam("client_secret", this.context.getAppSecret()).queryParam("redirect_uri", this.context.getRedirectUri()).build();
    }
}

