/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.stackoverflow;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.auth.nimble.stackoverflow.StackoverflowScope;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.lang.Gender;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.core.net.url.UrlDecoder;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;

public class StackOverflowProvider
extends AbstractProvider {
    public StackOverflowProvider(Context context) {
        super(context, Registry.STACK_OVERFLOW);
    }

    public StackOverflowProvider(Context context, CacheX cache) {
        super(context, Registry.STACK_OVERFLOW, cache);
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        String accessTokenUrl = this.accessTokenUrl(callback.getCode());
        HashMap form = new HashMap();
        UrlDecoder.decodeMap((String)accessTokenUrl, (String)"UTF-8").forEach(form::put);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        String response = Httpx.post((String)accessTokenUrl, form, header);
        Map accessTokenObject = (Map)JsonKit.toPojo((String)response, Map.class);
        this.checkResponse(accessTokenObject);
        return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken((String)accessTokenObject.get("access_token"))).expireIn(((Number)accessTokenObject.get("expires")).intValue())).build();
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        String userInfoUrl = Builder.fromUrl(this.complex.userinfo()).queryParam("access_token", authToken.getAccessToken()).queryParam("site", "stackoverflow").queryParam("key", this.context.getUnionId()).build();
        String response = Httpx.get((String)userInfoUrl);
        Map object = (Map)JsonKit.toPojo((String)response, Map.class);
        this.checkResponse(object);
        Map userObj = (Map)((List)object.get("items")).get(0);
        return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().rawJson(JsonKit.toJsonString((Object)userObj))).uuid((String)userObj.get("user_id"))).avatar((String)userObj.get("profile_image"))).location((String)userObj.get("location"))).nickname((String)userObj.get("display_name"))).blog((String)userObj.get("website_url"))).gender(Gender.UNKNOWN)).token(authToken)).source(this.complex.toString())).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(super.authorize(state)).queryParam("scope", this.getScopes(",", false, StackOverflowProvider.getDefaultScopes(StackoverflowScope.values()))).build();
    }

    private void checkResponse(Map<String, Object> object) {
        if (object.containsKey("error")) {
            throw new AuthorizedException((String)object.get("error_description"));
        }
    }
}

