/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.taobao;

import java.util.Map;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.ErrorCode;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.basic.entity.Message;
import org.miaixz.bus.core.lang.Gender;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.core.net.url.UrlDecoder;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;

public class TaobaoProvider
extends AbstractProvider {
    public TaobaoProvider(Context context) {
        super(context, Registry.TAOBAO);
    }

    public TaobaoProvider(Context context, CacheX cache) {
        super(context, Registry.TAOBAO, cache);
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        return ((AuthToken.AuthTokenBuilder)AuthToken.builder().accessCode(callback.getCode())).build();
    }

    private AuthToken getAuthToken(Map<String, Object> object) {
        this.checkResponse(object);
        return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken((String)object.get("access_token"))).expireIn(((Number)object.get("expires_in")).intValue())).tokenType((String)object.get("token_type"))).idToken((String)object.get("id_token"))).refreshToken((String)object.get("refresh_token"))).uid((String)object.get("taobao_user_id"))).openId((String)object.get("taobao_open_uid"))).build();
    }

    private void checkResponse(Map<String, Object> object) {
        if (object.containsKey("error")) {
            throw new AuthorizedException((String)object.get("error_description"));
        }
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        String response = this.doPostAuthorizationCode(authToken.getAccessCode());
        Map accessTokenObject = (Map)JsonKit.toPojo((String)response, Map.class);
        if (accessTokenObject.containsKey("error")) {
            throw new AuthorizedException((String)accessTokenObject.get("error_description"));
        }
        authToken = this.getAuthToken(accessTokenObject);
        String nick = UrlDecoder.decode((String)((String)accessTokenObject.get("taobao_user_nick")));
        return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().rawJson(JsonKit.toJsonString((Object)accessTokenObject))).uuid(StringKit.isEmpty((CharSequence)authToken.getUid()) ? authToken.getOpenId() : authToken.getUid())).username(nick)).nickname(nick)).gender(Gender.UNKNOWN)).token(authToken)).source(this.complex.toString())).build();
    }

    @Override
    public Message refresh(AuthToken authToken) {
        String tokenUrl = this.refreshTokenUrl(authToken.getRefreshToken());
        String response = Httpx.post((String)tokenUrl);
        Map accessTokenObject = (Map)JsonKit.toPojo((String)response, Map.class);
        return Message.builder().errcode(ErrorCode._SUCCESS.getKey()).data((Object)this.getAuthToken(accessTokenObject)).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(this.complex.authorize()).queryParam("response_type", "code").queryParam("client_id", this.context.getAppKey()).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("view", "web").queryParam("state", this.getRealState(state)).build();
    }
}

