/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.teambition;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Map;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.ErrorCode;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.basic.entity.Message;
import org.miaixz.bus.core.lang.Gender;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;

public class TeambitionProvider
extends AbstractProvider {
    public TeambitionProvider(Context context) {
        super(context, Registry.TEAMBITION);
    }

    public TeambitionProvider(Context context, CacheX cache) {
        super(context, Registry.TEAMBITION, cache);
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        HashMap<String, String> form = new HashMap<String, String>(7);
        form.put("client_id", this.context.getAppKey());
        form.put("client_secret", this.context.getAppSecret());
        form.put("code", callback.getCode());
        form.put("grant_type", "code");
        String response = Httpx.post((String)this.complex.accessToken(), form);
        Map accessTokenObject = (Map)JsonKit.toPojo((String)response, Map.class);
        this.checkResponse(accessTokenObject);
        return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken((String)accessTokenObject.get("access_token"))).refreshToken((String)accessTokenObject.get("refresh_token"))).build();
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        String accessToken = authToken.getAccessToken();
        HashMap<String, CallSite> header = new HashMap<String, CallSite>();
        header.put("Authorization", (CallSite)((Object)("OAuth2 " + accessToken)));
        String response = Httpx.get((String)this.complex.userinfo(), null, header);
        Map object = (Map)JsonKit.toPojo((String)response, Map.class);
        this.checkResponse(object);
        authToken.setUid((String)object.get("_id"));
        return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().rawJson(JsonKit.toJsonString((Object)object))).uuid((String)object.get("_id"))).username((String)object.get("name"))).nickname((String)object.get("name"))).avatar((String)object.get("avatarUrl"))).blog((String)object.get("website"))).location((String)object.get("location"))).email((String)object.get("email"))).gender(Gender.UNKNOWN)).token(authToken)).source(this.complex.toString())).build();
    }

    @Override
    public Message refresh(AuthToken authToken) {
        String uid = authToken.getUid();
        String refreshToken = authToken.getRefreshToken();
        HashMap<String, String> form = new HashMap<String, String>(4);
        form.put("_userId", uid);
        form.put("refresh_token", refreshToken);
        String response = Httpx.post((String)this.complex.refresh(), form);
        Map refreshTokenObject = (Map)JsonKit.toPojo((String)response, Map.class);
        this.checkResponse(refreshTokenObject);
        return Message.builder().errcode(ErrorCode._SUCCESS.getKey()).data(((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken((String)refreshTokenObject.get("access_token"))).refreshToken((String)refreshTokenObject.get("refresh_token"))).build()).build();
    }

    private void checkResponse(Map<String, Object> object) {
        if (object.containsKey("message") && object.containsKey("name")) {
            throw new AuthorizedException((String)object.get("name") + ", " + (String)object.get("message"));
        }
    }
}

