/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.toutiao;

import java.util.Map;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.ErrorCode;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.lang.Gender;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.extra.json.JsonKit;

public class ToutiaoProvider
extends AbstractProvider {
    public ToutiaoProvider(Context context) {
        super(context, Registry.TOUTIAO);
    }

    public ToutiaoProvider(Context context, CacheX cache) {
        super(context, Registry.TOUTIAO, cache);
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        String response = this.doPostAuthorizationCode(callback.getCode());
        Map accessTokenObject = (Map)JsonKit.toPojo((String)response, Map.class);
        this.checkResponse(accessTokenObject);
        return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken((String)accessTokenObject.get("access_token"))).expireIn(((Number)accessTokenObject.get("expires_in")).intValue())).openId((String)accessTokenObject.get("open_id"))).build();
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        String userResponse = this.doGetUserInfo(authToken);
        Map userProfile = (Map)JsonKit.toPojo((String)userResponse, Map.class);
        this.checkResponse(userProfile);
        Map user = (Map)userProfile.get("data");
        boolean isAnonymousUser = "14".equals(user.get("uid_type"));
        String anonymousUserName = "Anonymous User";
        return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().rawJson(JsonKit.toJsonString((Object)userProfile))).uuid((String)user.get("uid"))).username(isAnonymousUser ? anonymousUserName : (String)user.get("screen_name"))).nickname(isAnonymousUser ? anonymousUserName : (String)user.get("screen_name"))).avatar((String)user.get("avatar_url"))).remark((String)user.get("description"))).gender(Gender.of((String)((String)user.get("gender"))))).token(authToken)).source(this.complex.toString())).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(this.complex.authorize()).queryParam("response_type", "code").queryParam("client_key", this.context.getAppKey()).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("auth_only", 1).queryParam("display", 0).queryParam("state", this.getRealState(state)).build();
    }

    @Override
    protected String accessTokenUrl(String code) {
        return Builder.fromUrl(this.complex.accessToken()).queryParam("code", code).queryParam("client_key", this.context.getAppKey()).queryParam("client_secret", this.context.getAppSecret()).queryParam("grant_type", "authorization_code").build();
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        return Builder.fromUrl(this.complex.userinfo()).queryParam("client_key", this.context.getAppKey()).queryParam("access_token", authToken.getAccessToken()).build();
    }

    private void checkResponse(Map<String, Object> object) {
        if (object.containsKey("error_code")) {
            throw new AuthorizedException(ErrorCode.Toutiao.getErrorCode((String)object.get("error_code")).getValue());
        }
    }
}

