/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.twitter;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.codec.binary.Base64;
import org.miaixz.bus.core.lang.Algorithm;
import org.miaixz.bus.core.lang.Charset;
import org.miaixz.bus.core.net.url.UrlEncoder;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;

public class TwitterProvider
extends AbstractProvider {
    private static final String PREAMBLE = "OAuth";

    public TwitterProvider(Context context) {
        super(context, Registry.TWITTER);
    }

    public TwitterProvider(Context context, CacheX cache) {
        super(context, Registry.TWITTER, cache);
    }

    public static String generateNonce(int len) {
        String s = "0123456789QWERTYUIOPLKJHGFDSAZXCVBNMqwertyuioplkjhgfdsazxcvbnm";
        Random rng = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            int index = rng.nextInt(62);
            sb.append(s, index, index + 1);
        }
        return sb.toString();
    }

    public static String sign(Map<String, String> params, String method, String baseUrl, String apiSecret, String tokenSecret) {
        TreeMap<String, String> map = new TreeMap<String, String>(params);
        String text = Builder.parseMapToString(map, true);
        String baseStr = method.toUpperCase() + "&" + UrlEncoder.encodeAll((String)baseUrl) + "&" + UrlEncoder.encodeAll((String)text);
        String signKey = apiSecret + "&" + (StringKit.isEmpty((CharSequence)tokenSecret) ? "" : tokenSecret);
        byte[] signature = Builder.sign(signKey.getBytes(Charset.UTF_8), baseStr.getBytes(Charset.UTF_8), Algorithm.HMACSHA1.getValue());
        return new String(Base64.encode((byte[])signature, (boolean)false));
    }

    @Override
    public String authorize(String state) {
        AuthToken token = this.getRequestToken();
        return Builder.fromUrl(this.complex.authorize()).queryParam("oauth_token", token.getOauthToken()).build();
    }

    public AuthToken getRequestToken() {
        String baseUrl = "https://api.twitter.com/oauth/request_token";
        Map<String, String> form = this.buildOauthParams();
        form.put("oauth_callback", this.context.getRedirectUri());
        form.put("oauth_signature", TwitterProvider.sign(form, "POST", baseUrl, this.context.getAppSecret(), null));
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", this.buildHeader(form));
        header.put("User-Agent", "'Httpx' HTTP Client Simple-Http");
        String requestToken = Httpx.post((String)baseUrl, null, header);
        Map<String, String> res = Builder.parseStringToMap(requestToken);
        return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().oauthToken(res.get("oauth_token"))).oauthTokenSecret(res.get("oauth_token_secret"))).oauthCallbackConfirmed(Boolean.valueOf(res.get("oauth_callback_confirmed")))).build();
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        Map<String, String> headerMap = this.buildOauthParams();
        headerMap.put("oauth_token", callback.getOauth_token());
        headerMap.put("oauth_verifier", callback.getOauth_verifier());
        headerMap.put("oauth_signature", TwitterProvider.sign(headerMap, "POST", this.complex.accessToken(), this.context.getAppSecret(), callback.getOauth_token()));
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", this.buildHeader(headerMap));
        header.put("Content-Type", "application/x-www-form-urlencoded");
        HashMap<String, String> form = new HashMap<String, String>(3);
        form.put("oauth_verifier", callback.getOauth_verifier());
        String response = Httpx.post((String)this.complex.accessToken(), form, header);
        Map<String, String> requestToken = Builder.parseStringToMap(response);
        return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().oauthToken(requestToken.get("oauth_token"))).oauthTokenSecret(requestToken.get("oauth_token_secret"))).userId(requestToken.get("user_id"))).screenName(requestToken.get("screen_name"))).build();
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        Map<String, String> form = this.buildOauthParams();
        form.put("oauth_token", authToken.getOauthToken());
        HashMap<String, String> params = new HashMap<String, String>(form);
        params.put("include_entities", Boolean.toString(true));
        params.put("include_email", Boolean.toString(true));
        form.put("oauth_signature", TwitterProvider.sign(params, "GET", this.complex.userinfo(), this.context.getAppSecret(), authToken.getOauthTokenSecret()));
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", this.buildHeader(form));
        String response = Httpx.get((String)this.userInfoUrl(authToken), null, header);
        Map userInfo = (Map)JsonKit.toPojo((String)response, Map.class);
        if (userInfo == null || userInfo.isEmpty()) {
            throw new IllegalArgumentException("Failed to parse user info from response: " + response);
        }
        String rawJson = JsonKit.toJsonString((Object)userInfo);
        return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().rawJson(rawJson)).uuid((String)userInfo.get("id_str"))).username((String)userInfo.get("screen_name"))).nickname((String)userInfo.get("name"))).remark((String)userInfo.get("description"))).avatar((String)userInfo.get("profile_image_url_https"))).blog((String)userInfo.get("url"))).location((String)userInfo.get("location"))).avatar((String)userInfo.get("profile_image_url"))).email((String)userInfo.get("email"))).source(this.complex.getName())).token(authToken)).build();
    }

    private Map<String, String> buildOauthParams() {
        HashMap<String, String> params = new HashMap<String, String>(12);
        params.put("oauth_consumer_key", this.context.getAppKey());
        params.put("oauth_nonce", TwitterProvider.generateNonce(32));
        params.put("oauth_signature_method", "HMAC-SHA1");
        params.put("oauth_timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("oauth_version", "1.0");
        return params;
    }

    private String buildHeader(Map<String, String> oauthParams) {
        StringBuilder sb = new StringBuilder("OAuth ");
        for (Map.Entry<String, String> param : oauthParams.entrySet()) {
            sb.append(param.getKey()).append("=\"").append(UrlEncoder.encodeAll((String)param.getValue())).append('\"').append(", ");
        }
        return sb.deleteCharAt(sb.length() - 2).toString();
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        return Builder.fromUrl(this.complex.userinfo()).queryParam("include_entities", true).queryParam("include_email", true).build();
    }
}

