/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.vk;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.ErrorCode;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.auth.nimble.vk.VKScope;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.basic.entity.Message;
import org.miaixz.bus.core.basic.normal.Errors;
import org.miaixz.bus.core.data.id.ID;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;

public class VKProvider
extends AbstractProvider {
    public VKProvider(Context context) {
        super(context, Registry.VK);
    }

    public VKProvider(Context context, CacheX cache) {
        super(context, Registry.VK, cache);
    }

    @Override
    public String authorize(String state) {
        String realState = this.getRealState(state);
        Builder builder = Builder.fromUrl(super.authorize(state)).queryParam("scope", this.getScopes(" ", false, VKProvider.getDefaultScopes(VKScope.values())));
        if (this.context.isPkce()) {
            String cacheKey = this.complex.getName().concat(":code_verifier:").concat(realState);
            String codeVerifier = Builder.codeVerifier();
            String codeChallengeMethod = "S256";
            String codeChallenge = Builder.codeChallenge(codeChallengeMethod, codeVerifier);
            builder.queryParam("code_challenge", codeChallenge).queryParam("code_challenge_method", codeChallengeMethod);
            this.cache.write((Object)cacheKey, (Object)codeVerifier, TimeUnit.MINUTES.toMillis(10L));
        }
        return builder.build();
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        String response = this.doPostAuthorizationCode(callback);
        Map object = JsonKit.toMap((String)response);
        this.checkResponse(object);
        return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().idToken((String)object.get("id_token"))).accessToken((String)object.get("access_token"))).refreshToken((String)object.get("refresh_token"))).tokenType((String)object.get("token_type"))).scope((String)object.get("scope"))).deviceId(callback.getDevice_id())).userId((String)object.get("user_id"))).build();
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        String body = this.doGetUserInfo(authToken);
        Map object = JsonKit.toMap((String)body);
        this.checkResponse(object);
        Map userObj = JsonKit.toMap((String)((String)object.get("user")));
        return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().uuid((String)userObj.get("user_id"))).username((String)userObj.get("first_name"))).nickname((String)userObj.get("first_name") + " " + (String)userObj.get("last_name"))).avatar((String)userObj.get("avatar"))).email((String)userObj.get("email"))).token(authToken)).rawJson(JsonKit.toJsonString((Object)userObj))).source(this.complex.toString())).build();
    }

    @Override
    public Message refresh(AuthToken authToken) {
        HashMap<String, String> form = new HashMap<String, String>(7);
        form.put("grant_type", "refresh_token");
        form.put("refresh_token", authToken.getRefreshToken());
        form.put("state", ID.objectId());
        form.put("device_id", authToken.getDeviceId());
        form.put("client_id", this.context.getAppKey());
        form.put("ip", "10.10.10.10");
        return Message.builder().errcode(ErrorCode._SUCCESS.getKey()).data((Object)this.getToken(form, this.complex.refresh())).build();
    }

    @Override
    public Message revoke(AuthToken authToken) {
        String response = this.doPostRevoke(authToken);
        Map object = JsonKit.toMap((String)response);
        this.checkResponse(object);
        Errors errors = ((String)object.get("response")).equals("1") ? ErrorCode._SUCCESS : ErrorCode._FAILURE;
        return Message.builder().errcode(errors.getKey()).errmsg(errors.getValue()).build();
    }

    protected String doPostAuthorizationCode(Callback callback) {
        HashMap<String, String> form = new HashMap<String, String>(7);
        form.put("grant_type", "authorization_code");
        form.put("redirect_uri", this.context.getRedirectUri());
        form.put("client_id", this.context.getAppKey());
        form.put("code", callback.getCode());
        form.put("state", callback.getState());
        form.put("device_id", callback.getDevice_id());
        if (this.context.isPkce()) {
            String cacheKey = this.complex.getName().concat(":code_verifier:").concat(callback.getState());
            String codeVerifier = this.cache.read((Object)cacheKey).toString();
            form.put("code_verifier", codeVerifier);
        }
        return Httpx.post((String)this.complex.accessToken(), form, this.buildHeader());
    }

    private AuthToken getToken(Map<String, String> param, String url) {
        String response = Httpx.post((String)url, param, this.buildHeader());
        Map object = JsonKit.toMap((String)response);
        this.checkResponse(object);
        return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken((String)object.get("access_token"))).tokenType((String)object.get("token_type"))).expireIn(Integer.parseInt((String)object.get("expires_in")))).refreshToken((String)object.get("refresh_token"))).deviceId(param.get("device_id"))).build();
    }

    @Override
    protected String doGetUserInfo(AuthToken authToken) {
        HashMap<String, String> form = new HashMap<String, String>(7);
        form.put("access_token", authToken.getAccessToken());
        form.put("client_id", this.context.getAppKey());
        return Httpx.post((String)this.complex.userinfo(), form, this.buildHeader());
    }

    private void checkResponse(Map<String, String> object) {
        if (object.containsKey("error")) {
            throw new AuthorizedException(object.get("error_description"));
        }
        if (object.containsKey("message")) {
            throw new AuthorizedException(object.get("message"));
        }
    }

    private Map<String, String> buildHeader() {
        return Map.of("Content-Type", "application/x-www-form-urlencoded");
    }

    protected String doPostRevoke(AuthToken authToken) {
        HashMap<String, String> form = new HashMap<String, String>(7);
        form.put("access_token", authToken.getAccessToken());
        form.put("client_id", this.context.getAppKey());
        return Httpx.post((String)this.complex.revoke(), form, this.buildHeader());
    }
}

