/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.wechat.ee;

import java.util.HashMap;
import java.util.Map;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Complex;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.ErrorCode;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.wechat.AbstractWeChatProvider;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;

public abstract class AbstractWeChatEeProvider
extends AbstractWeChatProvider {
    public AbstractWeChatEeProvider(Context context, Complex complex) {
        super(context, complex);
    }

    public AbstractWeChatEeProvider(Context context, Complex complex, CacheX cache) {
        super(context, complex, cache);
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        String response = this.doGetAuthorizationCode(this.accessTokenUrl(null));
        Map<String, Object> object = this.checkResponse(response);
        String accessToken = (String)object.get("access_token");
        if (accessToken == null) {
            throw new AuthorizedException("Missing access_token in response");
        }
        Object expiresInObj = object.get("expires_in");
        int expiresIn = expiresInObj instanceof Number ? ((Number)expiresInObj).intValue() : 0;
        return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken(accessToken)).expireIn(expiresIn)).code(callback.getCode())).build();
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        String response = this.doGetUserInfo(authToken);
        Map<String, Object> object = this.checkResponse(response);
        if (!object.containsKey("userid")) {
            throw new AuthorizedException(ErrorCode.UNIDENTIFIED_PLATFORM.getKey(), new Object[]{this.complex});
        }
        String userId = (String)object.get("userid");
        String userTicket = (String)object.get("user_ticket");
        Map<String, Object> data = this.getUserDetail(authToken.getAccessToken(), userId, userTicket);
        String name = (String)data.get("name");
        String alias = (String)data.get("alias");
        String avatar = (String)data.get("avatar");
        String address = (String)data.get("address");
        String email = (String)data.get("email");
        String gender = (String)data.get("gender");
        return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().rawJson(JsonKit.toJsonString(data))).username(name)).nickname(alias)).avatar(avatar)).location(address)).email(email)).uuid(userId)).gender(AbstractWeChatEeProvider.getWechatRealGender(gender))).token(authToken)).source(this.complex.toString())).build();
    }

    private Map<String, Object> checkResponse(String response) {
        try {
            Map object = (Map)JsonKit.toPojo((String)response, Map.class);
            if (object == null) {
                throw new AuthorizedException("Failed to parse response: empty response");
            }
            Object errcodeObj = object.get("errcode");
            if (errcodeObj != null && !errcodeObj.equals(0)) {
                String errmsg = (String)object.get("errmsg");
                throw new AuthorizedException(errmsg != null ? errmsg : "Unknown error", this.complex.getName());
            }
            return object;
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse response: " + e.getMessage());
        }
    }

    @Override
    public String accessTokenUrl(String code) {
        return Builder.fromUrl(this.complex.accessToken()).queryParam("corpid", this.context.getAppKey()).queryParam("corpsecret", this.context.getAppSecret()).build();
    }

    @Override
    public String userInfoUrl(AuthToken authToken) {
        return Builder.fromUrl(this.complex.userinfo()).queryParam("access_token", authToken.getAccessToken()).queryParam("code", authToken.getCode()).build();
    }

    private Map<String, Object> getUserDetail(String accessToken, String userId, String userTicket) {
        String userInfoUrl = Builder.fromUrl("https://qyapi.weixin.qq.com/cgi-bin/user/get").queryParam("access_token", accessToken).queryParam("userid", userId).build();
        String userInfoResponse = Httpx.get((String)userInfoUrl);
        Map<String, Object> userInfo = this.checkResponse(userInfoResponse);
        if (StringKit.isNotEmpty((CharSequence)userTicket)) {
            String userDetailUrl = Builder.fromUrl("https://qyapi.weixin.qq.com/cgi-bin/auth/getuserdetail").queryParam("access_token", accessToken).build();
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("user_ticket", userTicket);
            String userDetailResponse = Httpx.post((String)userDetailUrl, (String)JsonKit.toJsonString(param), (String)"application/json");
            Map<String, Object> userDetail = this.checkResponse(userDetailResponse);
            userInfo.putAll(userDetail);
        }
        return userInfo;
    }
}

