/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.wechat.ee;

import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.ErrorCode;
import org.miaixz.bus.auth.nimble.wechat.ee.AbstractWeChatEeProvider;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.core.xyz.StringKit;

public class WeChatEeQrcodeProvider
extends AbstractWeChatEeProvider {
    public WeChatEeQrcodeProvider(Context context) {
        super(context, Registry.WECHAT_EE);
    }

    public WeChatEeQrcodeProvider(Context context, CacheX cache) {
        super(context, Registry.WECHAT_EE, cache);
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(this.complex.authorize()).queryParam("login_type", this.context.getLoginType()).queryParam("appid", this.context.getAppKey()).queryParam("agentid", this.context.getUnionId()).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("state", this.getRealState(state)).queryParam("lang", this.context.getLang()).build().concat("#wechat_redirect");
    }

    @Override
    protected void check(Context context) {
        super.check(context);
        if ("CorpApp".equals(context.getLoginType()) && StringKit.isEmpty((CharSequence)context.getUnionId())) {
            throw new AuthorizedException(ErrorCode.ILLEGAL_WECHAT_AGENT_ID.getKey(), new Object[]{this.complex});
        }
    }
}

