/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.wechat.ee;

import java.util.HashMap;
import java.util.Map;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Checker;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.ErrorCode;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.wechat.ee.AbstractWeChatEeProvider;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.basic.entity.Message;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;
import org.miaixz.bus.logger.Logger;

public class WeChatEeThirdQrcodeProvider
extends AbstractWeChatEeProvider {
    public WeChatEeThirdQrcodeProvider(Context context) {
        super(context, Registry.WECHAT_EE_QRCODE);
    }

    public WeChatEeThirdQrcodeProvider(Context context, CacheX cache) {
        super(context, Registry.WECHAT_EE_QRCODE, cache);
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(this.complex.authorize()).queryParam("appid", this.context.getAppKey()).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("state", this.getRealState(state)).queryParam("usertype", this.context.getType()).build();
    }

    @Override
    public Message login(Callback callback) {
        try {
            if (!this.context.isIgnoreState()) {
                Checker.check(callback.getState(), this.complex, this.cache);
            }
            AuthToken authToken = this.getAccessToken(callback);
            Material user = this.getUserInfo(authToken);
            return Message.builder().errcode(ErrorCode._SUCCESS.getKey()).data((Object)user).build();
        }
        catch (Exception e) {
            Logger.error((String)"Failed to login with auth authorization.", (Object[])new Object[]{e});
            return this.responseError(e);
        }
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        try {
            String response = this.doGetAuthorizationCode(this.accessTokenUrl());
            Map<String, Object> object = this.checkResponse(response);
            String accessToken = (String)object.get("provider_access_token");
            if (accessToken == null) {
                throw new AuthorizedException("Missing provider_access_token in response");
            }
            Object expiresInObj = object.get("expires_in");
            int expiresIn = expiresInObj instanceof Number ? ((Number)expiresInObj).intValue() : 0;
            return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken(accessToken)).expireIn(expiresIn)).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("\u4f01\u4e1a\u5fae\u4fe1\u83b7\u53d6token\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public String doGetAuthorizationCode(String code) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("corpid", this.context.getAppKey());
        data.put("provider_secret", this.context.getAppSecret());
        return Httpx.post((String)this.accessTokenUrl(code), (String)JsonKit.toJsonString(data), (String)"application/json");
    }

    public String accessTokenUrl() {
        return Builder.fromUrl(this.complex.accessToken()).build();
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        Map<String, Object> response = this.checkResponse(this.doGetUserInfo(authToken));
        return ((Material.MaterialBuilder)Material.builder().rawJson(JsonKit.toJsonString(response))).build();
    }

    @Override
    public String doGetUserInfo(AuthToken authToken) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("auth_code", authToken.getCode());
        return Httpx.post((String)this.userInfoUrl(authToken), (String)JsonKit.toJsonString(data), (String)"application/json");
    }

    @Override
    public String userInfoUrl(AuthToken authToken) {
        return Builder.fromUrl(this.complex.userinfo()).queryParam("access_token", authToken.getAccessToken()).build();
    }

    private Map<String, Object> checkResponse(String response) {
        try {
            Map object = (Map)JsonKit.toPojo((String)response, Map.class);
            if (object == null) {
                throw new AuthorizedException("Failed to parse response: empty response");
            }
            Object errcodeObj = object.get("errcode");
            if (errcodeObj != null && !errcodeObj.equals(0)) {
                String errmsg = (String)object.get("errmsg");
                throw new AuthorizedException(errmsg != null ? errmsg : "Unknown error", this.complex.getName());
            }
            return object;
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse response: " + e.getMessage());
        }
    }
}

