/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.wechat.mini;

import lombok.Generated;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;

public class WeChatMiniProvider
extends AbstractProvider {
    public WeChatMiniProvider(Context context) {
        super(context, Registry.WECHAT_MINI);
    }

    public WeChatMiniProvider(Context context, CacheX cache) {
        super(context, Registry.WECHAT_MINI, cache);
    }

    @Override
    public AuthToken getAccessToken(Callback authCallback) {
        String response = Httpx.get((String)this.accessTokenUrl(authCallback.getCode()));
        JSCode2SessionResponse accessTokenObject = (JSCode2SessionResponse)JsonKit.toPojo((String)response, JSCode2SessionResponse.class);
        assert (accessTokenObject != null);
        this.checkResponse(accessTokenObject);
        return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().openId(accessTokenObject.getOpenid())).unionId(accessTokenObject.getUnionid())).accessToken(accessTokenObject.getSession_key())).build();
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().username("")).nickname("")).avatar("")).uuid(authToken.getOpenId())).token(authToken)).source(this.complex.toString())).build();
    }

    private void checkResponse(JSCode2SessionResponse response) {
        if (!"0".equals(response.getErrcode())) {
            throw new AuthorizedException(response.getErrcode(), response.getErrmsg());
        }
    }

    @Override
    protected String accessTokenUrl(String code) {
        return Builder.fromUrl(this.complex.accessToken()).queryParam("appid", this.context.getAppKey()).queryParam("secret", this.context.getAppSecret()).queryParam("js_code", code).queryParam("grant_type", "authorization_code").build();
    }

    private static class JSCode2SessionResponse {
        private String errcode;
        private String errmsg;
        private String session_key;
        private String openid;
        private String unionid;

        @Generated
        public JSCode2SessionResponse() {
        }

        @Generated
        public String getErrcode() {
            return this.errcode;
        }

        @Generated
        public String getErrmsg() {
            return this.errmsg;
        }

        @Generated
        public String getSession_key() {
            return this.session_key;
        }

        @Generated
        public String getOpenid() {
            return this.openid;
        }

        @Generated
        public String getUnionid() {
            return this.unionid;
        }

        @Generated
        public void setErrcode(String errcode) {
            this.errcode = errcode;
        }

        @Generated
        public void setErrmsg(String errmsg) {
            this.errmsg = errmsg;
        }

        @Generated
        public void setSession_key(String session_key) {
            this.session_key = session_key;
        }

        @Generated
        public void setOpenid(String openid) {
            this.openid = openid;
        }

        @Generated
        public void setUnionid(String unionid) {
            this.unionid = unionid;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JSCode2SessionResponse)) {
                return false;
            }
            JSCode2SessionResponse other = (JSCode2SessionResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$errcode = this.getErrcode();
            String other$errcode = other.getErrcode();
            if (this$errcode == null ? other$errcode != null : !this$errcode.equals(other$errcode)) {
                return false;
            }
            String this$errmsg = this.getErrmsg();
            String other$errmsg = other.getErrmsg();
            if (this$errmsg == null ? other$errmsg != null : !this$errmsg.equals(other$errmsg)) {
                return false;
            }
            String this$session_key = this.getSession_key();
            String other$session_key = other.getSession_key();
            if (this$session_key == null ? other$session_key != null : !this$session_key.equals(other$session_key)) {
                return false;
            }
            String this$openid = this.getOpenid();
            String other$openid = other.getOpenid();
            if (this$openid == null ? other$openid != null : !this$openid.equals(other$openid)) {
                return false;
            }
            String this$unionid = this.getUnionid();
            String other$unionid = other.getUnionid();
            return !(this$unionid == null ? other$unionid != null : !this$unionid.equals(other$unionid));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof JSCode2SessionResponse;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $errcode = this.getErrcode();
            result = result * 59 + ($errcode == null ? 43 : $errcode.hashCode());
            String $errmsg = this.getErrmsg();
            result = result * 59 + ($errmsg == null ? 43 : $errmsg.hashCode());
            String $session_key = this.getSession_key();
            result = result * 59 + ($session_key == null ? 43 : $session_key.hashCode());
            String $openid = this.getOpenid();
            result = result * 59 + ($openid == null ? 43 : $openid.hashCode());
            String $unionid = this.getUnionid();
            result = result * 59 + ($unionid == null ? 43 : $unionid.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WeChatMiniProvider.JSCode2SessionResponse(errcode=" + this.getErrcode() + ", errmsg=" + this.getErrmsg() + ", session_key=" + this.getSession_key() + ", openid=" + this.getOpenid() + ", unionid=" + this.getUnionid() + ")";
        }
    }
}

