/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.wechat.open;

import java.util.Map;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.ErrorCode;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.wechat.AbstractWeChatProvider;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.basic.entity.Message;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;

public class WeChatOpenProvider
extends AbstractWeChatProvider {
    public WeChatOpenProvider(Context context) {
        super(context, Registry.WECHAT_OPEN);
    }

    public WeChatOpenProvider(Context context, CacheX cache) {
        super(context, Registry.WECHAT_OPEN, cache);
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        return this.getToken(this.accessTokenUrl(callback.getCode()));
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        String openId = authToken.getOpenId();
        String response = this.doGetUserInfo(authToken);
        try {
            Map object = (Map)JsonKit.toPojo((String)response, Map.class);
            if (object == null) {
                throw new AuthorizedException("Failed to parse user info response: empty response");
            }
            this.checkResponse(object);
            String country = (String)object.get("country");
            String province = (String)object.get("province");
            String city = (String)object.get("city");
            String location = String.format("%s-%s-%s", country, province, city);
            String unionId = (String)object.get("unionid");
            if (unionId != null) {
                authToken.setUnionId(unionId);
            }
            String nickname = (String)object.get("nickname");
            String headimgurl = (String)object.get("headimgurl");
            String sex = (String)object.get("sex");
            return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().rawJson(JsonKit.toJsonString((Object)object))).username(nickname)).nickname(nickname)).avatar(headimgurl)).location(location)).uuid(openId)).gender(WeChatOpenProvider.getWechatRealGender(sex))).token(authToken)).source(this.complex.toString())).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse user info response: " + e.getMessage());
        }
    }

    @Override
    public Message refresh(AuthToken authToken) {
        return Message.builder().errcode(ErrorCode._SUCCESS.getKey()).data((Object)this.getToken(this.refreshTokenUrl(authToken.getRefreshToken()))).build();
    }

    private void checkResponse(Map<String, Object> object) {
        if (object.containsKey("errcode")) {
            String errcode = String.valueOf(object.get("errcode"));
            String errmsg = (String)object.get("errmsg");
            throw new AuthorizedException(errcode, errmsg != null ? errmsg : "Unknown error");
        }
    }

    private AuthToken getToken(String accessTokenUrl) {
        String response = Httpx.get((String)accessTokenUrl);
        try {
            Map accessTokenObject = (Map)JsonKit.toPojo((String)response, Map.class);
            if (accessTokenObject == null) {
                throw new AuthorizedException("Failed to parse token response: empty response");
            }
            this.checkResponse(accessTokenObject);
            String accessToken = (String)accessTokenObject.get("access_token");
            if (accessToken == null) {
                throw new AuthorizedException("Missing access_token in response");
            }
            String refreshToken = (String)accessTokenObject.get("refresh_token");
            Object expiresInObj = accessTokenObject.get("expires_in");
            int expiresIn = expiresInObj instanceof Number ? ((Number)expiresInObj).intValue() : 0;
            String openId = (String)accessTokenObject.get("openid");
            return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken(accessToken)).refreshToken(refreshToken)).expireIn(expiresIn)).openId(openId)).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse token response: " + e.getMessage());
        }
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(this.complex.authorize()).queryParam("response_type", "code").queryParam("appid", this.context.getAppKey()).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("scope", "snsapi_login").queryParam("state", this.getRealState(state)).build();
    }

    @Override
    protected String accessTokenUrl(String code) {
        return Builder.fromUrl(this.complex.accessToken()).queryParam("code", code).queryParam("appid", this.context.getAppKey()).queryParam("secret", this.context.getAppSecret()).queryParam("grant_type", "authorization_code").build();
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        return Builder.fromUrl(this.complex.userinfo()).queryParam("access_token", authToken.getAccessToken()).queryParam("openid", authToken.getOpenId()).queryParam("lang", "zh_CN").build();
    }

    @Override
    protected String refreshTokenUrl(String refreshToken) {
        return Builder.fromUrl(this.complex.refresh()).queryParam("appid", this.context.getAppKey()).queryParam("refresh_token", refreshToken).queryParam("grant_type", "refresh_token").build();
    }
}

