/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.weibo;

import java.util.HashMap;
import java.util.Map;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.ErrorCode;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.auth.nimble.weibo.WeiboScope;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.basic.entity.Message;
import org.miaixz.bus.core.basic.normal.Errors;
import org.miaixz.bus.core.lang.Gender;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.core.xyz.NetKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;

public class WeiboProvider
extends AbstractProvider {
    public WeiboProvider(Context context) {
        super(context, Registry.WEIBO);
    }

    public WeiboProvider(Context context, CacheX cache) {
        super(context, Registry.WEIBO, cache);
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        String response = this.doPostAuthorizationCode(callback.getCode());
        try {
            Map accessTokenObject = (Map)JsonKit.toPojo((String)response, Map.class);
            if (accessTokenObject == null) {
                throw new AuthorizedException("Failed to parse access token response: empty response");
            }
            if (accessTokenObject.containsKey("error")) {
                String errorDescription = (String)accessTokenObject.get("error_description");
                throw new AuthorizedException(errorDescription != null ? errorDescription : "Unknown error");
            }
            String accessToken = (String)accessTokenObject.get("access_token");
            if (accessToken == null) {
                throw new AuthorizedException("Missing access_token in response");
            }
            String uid = (String)accessTokenObject.get("uid");
            Object expiresInObj = accessTokenObject.get("expires_in");
            int expiresIn = expiresInObj instanceof Number ? ((Number)expiresInObj).intValue() : 0;
            return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken(accessToken)).uid(uid)).openId(uid)).expireIn(expiresIn)).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse access token response: " + e.getMessage());
        }
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        String accessToken = authToken.getAccessToken();
        String uid = authToken.getUid();
        String oauthParam = String.format("uid=%s&access_token=%s", uid, accessToken);
        HashMap<String, Object> header = new HashMap<String, Object>();
        header.put("Authorization", "OAuth2 " + oauthParam);
        header.put("API-RemoteIP", NetKit.getLocalhostStringV4());
        String userInfo = Httpx.get((String)this.userInfoUrl(authToken), null, header);
        try {
            Map object = (Map)JsonKit.toPojo((String)userInfo, Map.class);
            if (object == null) {
                throw new AuthorizedException("Failed to parse user info response: empty response");
            }
            if (object.containsKey("error")) {
                String error = (String)object.get("error");
                throw new AuthorizedException(error != null ? error : "Unknown error");
            }
            String id = String.valueOf(object.get("id"));
            if (id == null) {
                throw new AuthorizedException("Missing id in user info response");
            }
            String name = (String)object.get("name");
            String profileImageUrl = (String)object.get("profile_image_url");
            String url = (String)object.get("url");
            String profileUrl = (String)object.get("profile_url");
            String screenName = (String)object.get("screen_name");
            String location = (String)object.get("location");
            String description = (String)object.get("description");
            String gender = (String)object.get("gender");
            return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().rawJson(JsonKit.toJsonString((Object)object))).uuid(id)).username(name)).avatar(profileImageUrl)).blog((String)(StringKit.isEmpty((CharSequence)url) ? "https://weibo.com/" + profileUrl : url))).nickname(screenName)).location(location)).remark(description)).gender(Gender.of((String)gender))).token(authToken)).source(this.complex.toString())).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse user info response: " + e.getMessage());
        }
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        return Builder.fromUrl(this.complex.userinfo()).queryParam("access_token", authToken.getAccessToken()).queryParam("uid", authToken.getUid()).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(super.authorize(state)).queryParam("scope", this.getScopes(",", false, WeiboProvider.getDefaultScopes(WeiboScope.values()))).build();
    }

    @Override
    public Message revoke(AuthToken authToken) {
        String response = this.doGetRevoke(authToken);
        try {
            Map object = (Map)JsonKit.toPojo((String)response, Map.class);
            if (object == null) {
                throw new AuthorizedException("Failed to parse revoke response: empty response");
            }
            if (object.containsKey("error")) {
                String error = (String)object.get("error");
                return Message.builder().errcode(ErrorCode._FAILURE.getKey()).errmsg(error != null ? error : "Unknown error").build();
            }
            Object resultObj = object.get("result");
            boolean result = resultObj instanceof Boolean ? (Boolean)resultObj : false;
            Errors status = result ? ErrorCode._SUCCESS : ErrorCode._FAILURE;
            return Message.builder().errcode(status.getKey()).errmsg(status.getValue()).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse revoke response: " + e.getMessage());
        }
    }
}

