/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.auth.nimble.ximalaya;

import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.miaixz.bus.auth.Builder;
import org.miaixz.bus.auth.Context;
import org.miaixz.bus.auth.Registry;
import org.miaixz.bus.auth.magic.AuthToken;
import org.miaixz.bus.auth.magic.Callback;
import org.miaixz.bus.auth.magic.Material;
import org.miaixz.bus.auth.nimble.AbstractProvider;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.codec.binary.Base64;
import org.miaixz.bus.core.lang.Algorithm;
import org.miaixz.bus.core.lang.Charset;
import org.miaixz.bus.core.lang.Gender;
import org.miaixz.bus.core.lang.exception.AuthorizedException;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.http.Httpx;

public class XimalayaProvider
extends AbstractProvider {
    public XimalayaProvider(Context context) {
        super(context, Registry.XIMALAYA);
    }

    public XimalayaProvider(Context context, CacheX cache) {
        super(context, Registry.XIMALAYA, cache);
    }

    private static String sign(Map<String, String> params, String clientSecret) {
        TreeMap<String, String> map = new TreeMap<String, String>(params);
        String baseStr = Base64.encode((CharSequence)Builder.parseMapToString(map, false));
        byte[] sign = Builder.sign(clientSecret.getBytes(Charset.UTF_8), baseStr.getBytes(Charset.UTF_8), Algorithm.HMACSHA1.getValue());
        StringBuilder builder = null;
        try {
            byte[] byteData;
            builder = new StringBuilder();
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(sign);
            for (byte byteDatum : byteData = md5.digest()) {
                builder.append(Integer.toString((byteDatum & 0xFF) + 256, 16).substring(1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null == builder ? "" : builder.toString();
    }

    @Override
    public AuthToken getAccessToken(Callback callback) {
        HashMap<String, String> map = new HashMap<String, String>(9);
        map.put("code", callback.getCode());
        map.put("client_id", this.context.getAppKey());
        map.put("client_secret", this.context.getAppSecret());
        map.put("device_id", this.context.getDeviceId());
        map.put("grant_type", "authorization_code");
        map.put("redirect_uri", this.context.getRedirectUri());
        String response = Httpx.post((String)this.complex.accessToken(), map);
        try {
            Map accessTokenObject = (Map)JsonKit.toPojo((String)response, Map.class);
            if (accessTokenObject == null) {
                throw new AuthorizedException("Failed to parse access token response: empty response");
            }
            this.checkResponse(accessTokenObject);
            String accessToken = (String)accessTokenObject.get("access_token");
            if (accessToken == null) {
                throw new AuthorizedException("Missing access_token in response");
            }
            String refreshToken = (String)accessTokenObject.get("refresh_token");
            Object expiresInObj = accessTokenObject.get("expires_in");
            int expiresIn = expiresInObj instanceof Number ? ((Number)expiresInObj).intValue() : 0;
            String uid = (String)accessTokenObject.get("uid");
            return ((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)((AuthToken.AuthTokenBuilder)AuthToken.builder().accessToken(accessToken)).refreshToken(refreshToken)).expireIn(expiresIn)).uid(uid)).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse access token response: " + e.getMessage());
        }
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(this.complex.authorize()).queryParam("response_type", "code").queryParam("client_id", this.context.getAppKey()).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("state", this.getRealState(state)).queryParam("client_os_type", "3").queryParam("device_id", this.context.getDeviceId()).build();
    }

    private void checkResponse(Map<String, Object> object) {
        if (object.containsKey("errcode")) {
            String errorNo = String.valueOf(object.get("error_no"));
            String errorDesc = (String)object.get("error_desc");
            throw new AuthorizedException(errorNo, errorDesc != null ? errorDesc : "Unknown error");
        }
    }

    @Override
    public Material getUserInfo(AuthToken authToken) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("app_key", this.context.getAppKey());
        map.put("client_os_type", (String)ObjectKit.defaultIfNull((Object)this.context.getType(), (Object)3));
        map.put("device_id", this.context.getDeviceId());
        map.put("pack_id", this.context.getUnionId());
        map.put("access_token", authToken.getAccessToken());
        map.put("sig", XimalayaProvider.sign(map, this.context.getAppSecret()));
        String rawUserInfo = Httpx.get((String)this.complex.userinfo(), map);
        try {
            Map object = (Map)JsonKit.toPojo((String)rawUserInfo, Map.class);
            if (object == null) {
                throw new AuthorizedException("Failed to parse user info response: empty response");
            }
            this.checkResponse(object);
            String id = (String)object.get("id");
            if (id == null) {
                throw new AuthorizedException("Missing id in user info response");
            }
            String nickname = (String)object.get("nickname");
            String avatarUrl = (String)object.get("avatar_url");
            return ((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)((Material.MaterialBuilder)Material.builder().uuid(id)).nickname(nickname)).avatar(avatarUrl)).rawJson(JsonKit.toJsonString((Object)object))).source(this.complex.toString())).token(authToken)).gender(Gender.UNKNOWN)).build();
        }
        catch (Exception e) {
            throw new AuthorizedException("Failed to parse user info response: " + e.getMessage());
        }
    }
}

