/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.base.advice;

import org.miaixz.bus.core.basic.advice.ErrorAdvice;
import org.miaixz.bus.core.basic.normal.ErrorCode;
import org.miaixz.bus.core.basic.spring.Controller;
import org.miaixz.bus.core.instance.Instances;
import org.miaixz.bus.core.lang.exception.BusinessException;
import org.miaixz.bus.core.lang.exception.CrontabException;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.lang.exception.ValidateException;
import org.miaixz.bus.core.xyz.StringKit;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.http.HttpStatus;
import org.springframework.ui.Model;
import org.springframework.validation.BindException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.NoHandlerFoundException;

@ControllerAdvice
@RestControllerAdvice
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class BaseAdvice
extends Controller {
    @InitBinder
    public void initBinder(WebDataBinder binder) {
    }

    @ModelAttribute
    public void addAttributes(Model model) {
    }

    @ResponseBody
    @ExceptionHandler(value={Exception.class})
    public Object defaultException(Exception e) {
        this.defaultExceptionHandler(e);
        return BaseAdvice.write((String)ErrorCode.EM_FAILURE);
    }

    @ResponseBody
    @ExceptionHandler(value={InternalException.class})
    public Object InternalException(InternalException e) {
        this.defaultExceptionHandler((Exception)e);
        if (StringKit.isBlank((CharSequence)e.getErrcode())) {
            return BaseAdvice.write((String)ErrorCode.EM_100510);
        }
        return BaseAdvice.write((String)e.getErrcode(), (String)e.getErrmsg());
    }

    @ResponseBody
    @ExceptionHandler(value={BusinessException.class})
    public Object businessException(BusinessException e) {
        this.defaultExceptionHandler((Exception)e);
        if (StringKit.isBlank((CharSequence)e.getErrcode())) {
            return BaseAdvice.write((String)ErrorCode.EM_100513);
        }
        return BaseAdvice.write((String)e.getErrcode());
    }

    @ResponseBody
    @ExceptionHandler(value={CrontabException.class})
    public Object crontabException(CrontabException e) {
        this.defaultExceptionHandler((Exception)e);
        if (StringKit.isBlank((CharSequence)e.getErrcode())) {
            return BaseAdvice.write((String)ErrorCode.EM_100600);
        }
        return BaseAdvice.write((String)e.getErrcode(), (String)e.getErrmsg());
    }

    @ResponseBody
    @ExceptionHandler(value={ValidateException.class})
    public Object validateException(ValidateException e) {
        this.defaultExceptionHandler((Exception)e);
        if (StringKit.isBlank((CharSequence)e.getErrcode())) {
            return BaseAdvice.write((String)ErrorCode.EM_100510);
        }
        return BaseAdvice.write((String)e.getErrcode(), (String)e.getErrmsg());
    }

    @ResponseBody
    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public Object httpRequestMethodNotSupportedException(HttpRequestMethodNotSupportedException e) {
        this.defaultExceptionHandler((Exception)e);
        return BaseAdvice.write((String)ErrorCode.EM_100507);
    }

    @ResponseBody
    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    public Object httpMediaTypeNotSupportedException(HttpMediaTypeNotSupportedException e) {
        this.defaultExceptionHandler((Exception)e);
        return BaseAdvice.write((String)ErrorCode.EM_100508);
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={NoHandlerFoundException.class})
    public Object noHandlerFoundException(NoHandlerFoundException e) {
        this.defaultExceptionHandler((Exception)e);
        return BaseAdvice.write((String)ErrorCode.EM_100509);
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={MethodArgumentNotValidException.class, BindException.class})
    public Object handleBodyValidException(MethodArgumentNotValidException e) {
        this.defaultExceptionHandler((Exception)e);
        return BaseAdvice.write((String)ErrorCode.EM_100511);
    }

    public void defaultExceptionHandler(Exception ex) {
        try {
            ((ErrorAdvice)Instances.singletion(ErrorAdvice.class)).handler(ex);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

