/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.base.service;

import java.util.ArrayList;
import java.util.List;
import org.miaixz.bus.base.entity.BaseEntity;
import org.miaixz.bus.base.mapper.BaseMapper;
import org.miaixz.bus.base.service.BaseService;
import org.miaixz.bus.core.basic.entity.Result;
import org.miaixz.bus.core.xyz.FieldKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.mapper.entity.Condition;
import org.miaixz.bus.pager.Page;
import org.miaixz.bus.pager.PageContext;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultService<Mapper extends BaseMapper<T>, T extends BaseEntity>
implements BaseService<T> {
    @Autowired
    protected Mapper mapper;

    @Override
    public String insert(T entity) {
        this.setValue(entity);
        this.mapper.insert(entity);
        return entity.getId();
    }

    @Override
    public String insertSelective(T entity) {
        this.setValue(entity);
        this.mapper.insertSelective(entity);
        return entity.getId();
    }

    @Override
    public Object insertBatch(List<T> list) {
        ArrayList data = new ArrayList();
        list.forEach(item -> {
            String id = this.insertSelective((T)item);
            data.add(id);
        });
        return data;
    }

    @Override
    public Object insertBatchSelective(List<T> list) {
        ArrayList data = new ArrayList();
        list.forEach(item -> {
            String id = this.insertSelective((T)item);
            data.add(id);
        });
        return data;
    }

    @Override
    public int remove(T entity) {
        ((BaseEntity)((Object)entity)).setStatus("-1");
        ((BaseEntity)((Object)entity)).setUpdate(entity);
        return this.mapper.updateByPrimaryKey(entity);
    }

    @Override
    public int delete(T entity) {
        return this.mapper.delete(entity);
    }

    @Override
    public int deleteById(Object id) {
        return this.mapper.deleteByPrimaryKey(id);
    }

    @Override
    public int deleteByIds(String id) {
        return this.mapper.deleteByIds(StringKit.split((String)id));
    }

    @Override
    public int deleteByWhere(Object object) {
        return this.mapper.deleteByCondition(object);
    }

    @Override
    public int updateById(T entity) {
        ((BaseEntity)((Object)entity)).setUpdate(entity);
        return this.mapper.updateByPrimaryKey(entity);
    }

    @Override
    public int updateSelectiveById(T entity) {
        ((BaseEntity)((Object)entity)).setUpdate(entity);
        return this.mapper.updateByPrimaryKeySelective(entity);
    }

    @Override
    public T updateByIdCas(T entity, String locking) {
        Condition condition = new Condition(entity.getClass());
        Object before = FieldKit.getFieldValue(entity, (String)locking);
        Object id = FieldKit.getFieldValue(entity, (String)"id");
        condition.createCriteria().andEqualTo(locking, before);
        condition.createCriteria().andEqualTo("id", id);
        this.updateByWhereSelective(entity, (Object)condition);
        return entity;
    }

    @Override
    public T updateSelectiveByIdOrInsert(T entity) {
        if (StringKit.isEmpty((CharSequence)entity.getId())) {
            this.insert(entity);
        } else {
            ((BaseEntity)((Object)entity)).setUpdate(entity);
            this.mapper.updateByPrimaryKeySelective(entity);
        }
        return entity;
    }

    @Override
    public int updateByWhere(T entity, Object object) {
        ((BaseEntity)((Object)entity)).setUpdate(entity);
        return this.mapper.updateByCondition(entity, object);
    }

    @Override
    public int updateByWhereSelective(T entity, Object object) {
        ((BaseEntity)((Object)entity)).setUpdate(entity);
        return this.mapper.updateByConditionSelective(entity, object);
    }

    @Override
    public int updateStatus(T entity) {
        ((BaseEntity)((Object)entity)).setUpdate(entity);
        return this.mapper.updateByPrimaryKeySelective(entity);
    }

    @Override
    public T selectOne(T entity) {
        return (T)((Object)((BaseEntity)((Object)this.mapper.selectOne(entity))));
    }

    @Override
    public T selectById(Object id) {
        return (T)((Object)((BaseEntity)((Object)this.mapper.selectByPrimaryKey(id))));
    }

    @Override
    public int selectCountByWhere(Object object) {
        return this.mapper.selectCountByCondition(object);
    }

    @Override
    public int selectCount(T entity) {
        return this.mapper.selectCount(entity);
    }

    @Override
    public List<T> selectListByIds(String id) {
        return this.mapper.selectByIds(StringKit.split((String)id));
    }

    @Override
    public List<T> selectList(T entity) {
        return this.mapper.select(entity);
    }

    @Override
    public List<T> selectListAll() {
        return this.mapper.selectAll();
    }

    @Override
    public List<T> selectByWhere(Object where) {
        return this.mapper.selectByCondition(where);
    }

    @Override
    public Result<T> page(T entity) {
        PageContext.startPage((int)((BaseEntity)((Object)entity)).getPageNo(), (int)((BaseEntity)((Object)entity)).getPageSize());
        if (StringKit.isNotEmpty((CharSequence)((BaseEntity)((Object)entity)).getOrderBy())) {
            PageContext.orderBy((String)((BaseEntity)((Object)entity)).getOrderBy());
        }
        Page list = (Page)this.mapper.select(entity);
        return Result.builder().rows(list.getResult()).total(list.getTotal()).build();
    }

    protected String setValue(T entity) {
        if (ObjectKit.isEmpty(entity)) {
            return null;
        }
        if (StringKit.isEmpty((CharSequence)((BaseEntity)((Object)entity)).getStatus())) {
            ((BaseEntity)((Object)entity)).setStatus("1");
        }
        ((BaseEntity)((Object)entity)).setValue(entity);
        return entity.getId();
    }
}

